/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.util.List;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.repository.MetadataRatingByIpRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.specification.MetadataFileUploadSpecs;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DraftUtilities {
    @Autowired
    private IMetadataManager metadataManager;
    @Autowired
    private MetadataValidationRepository metadataValidationRepository;
    @Autowired
    private MetadataFileUploadRepository metadataFileUploadRepository;
    @Autowired
    private EsSearchManager searchManager;
    @Autowired
    private XmlSerializer xmlSerializer;
    @Autowired
    private IMetadataOperations metadataOperations;
    @Autowired
    private MetadataStatusRepository metadataStatusRepository;
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;
    @Autowired
    private MetadataRatingByIpRepository metadataRatingByIpRepository;
    @Autowired
    private IMetadataUtils draftMetadataUtils;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    @Qualifier(value="resourceStore")
    private Store store;

    public AbstractMetadata replaceMetadataWithDraft(AbstractMetadata md) {
        MetadataDraft draft = this.metadataDraftRepository.findOneByUuid(md.getUuid());
        if (draft != null) {
            return this.replaceMetadataWithDraft(md, (AbstractMetadata)draft);
        }
        return md;
    }

    public AbstractMetadata replaceMetadataWithDraft(AbstractMetadata md, AbstractMetadata draft) {
        Log.trace((String)"geonetwork.datamanager", (Object)("Found approved record with id " + md.getId()));
        Log.trace((String)"geonetwork.datamanager", (Object)("Found draft with id " + draft.getId()));
        List validations = this.metadataValidationRepository.findAllById_MetadataId(draft.getId());
        this.metadataValidationRepository.deleteAll(MetadataValidationSpecs.hasMetadataId((int)md.getId()));
        for (Object draftValidation : validations) {
            MetadataValidation metadataValidation = new MetadataValidation().setId(new MetadataValidationId(md.getId(), draftValidation.getId().getValidationType())).setStatus(draftValidation.getStatus()).setRequired(draftValidation.isRequired()).setValid(draftValidation.isValid()).setValidationDate(draftValidation.getValidationDate()).setNumTests(draftValidation.getNumTests()).setNumFailures(draftValidation.getNumFailures()).setReportUrl(draftValidation.getReportUrl()).setReportContent(draftValidation.getReportContent());
            this.metadataValidationRepository.save((Object)metadataValidation);
            this.metadataValidationRepository.delete(draftValidation);
        }
        List statuses = this.metadataStatusRepository.findAllByMetadataId(draft.getId(), SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.metadataId}));
        for (Object old : statuses) {
            MetadataStatus st = new MetadataStatus();
            st.setChangeMessage(old.getChangeMessage());
            st.setCloseDate(old.getCloseDate());
            st.setCurrentState(old.getCurrentState());
            st.setOwner(old.getOwner());
            st.setPreviousState(old.getPreviousState());
            st.setStatusValue(old.getStatusValue());
            st.setChangeDate(old.getChangeDate());
            st.setUserId(old.getUserId());
            st.setMetadataId(md.getId());
            st.setUuid(md.getUuid());
            try {
                st.setTitles(this.metadataUtils.extractTitles(Integer.toString(md.getId())));
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.datamanager", (Object)String.format("Error locating titles for metadata id: %d", md.getId()), (Throwable)e);
            }
            this.metadataStatusRepository.save((Object)st);
            this.metadataStatusRepository.delete(old);
        }
        this.draftMetadataUtils.replaceFiles(draft, md);
        this.metadataFileUploadRepository.deleteAll(MetadataFileUploadSpecs.hasMetadataId((int)md.getId()));
        List fileUploads = this.metadataFileUploadRepository.findAll(MetadataFileUploadSpecs.hasMetadataId((int)draft.getId()));
        for (MetadataFileUpload fu : fileUploads) {
            fu.setMetadataId(md.getId());
            this.metadataFileUploadRepository.save((Object)fu);
        }
        try {
            ServiceContext context = ServiceContext.get();
            Element xmlData = draft.getXmlData(false);
            String changeDate = draft.getDataInfo().getChangeDate().getDateAndTime();
            this.store.delResources(context, draft.getUuid(), Boolean.valueOf(false));
            this.removeDraft((MetadataDraft)draft);
            Log.trace((String)"geonetwork.datamanager", (Object)("Update record with id " + md.getId()));
            md = this.metadataManager.updateMetadata(context, String.valueOf(md.getId()), xmlData, false, false, true, context.getLanguage(), changeDate, true);
            Log.info((String)"geonetwork.datamanager", (Object)("Record updated with draft contents: " + md.getId()));
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.datamanager", (Object)("Error upgrading from draft record with id " + md.getId()), (Throwable)e);
        }
        return md;
    }

    public void removeDraft(MetadataDraft draft) {
        Integer id = draft.getId();
        if (!this.metadataDraftRepository.existsById((Object)id)) {
            return;
        }
        Log.trace((String)"geonetwork.datamanager", (Object)("Removing draft " + draft));
        try {
            this.metadataOperations.deleteMetadataOper(String.valueOf(id), false);
            this.metadataRatingByIpRepository.deleteAllById_MetadataId(id.intValue());
            this.metadataValidationRepository.deleteAllById_MetadataId(id);
            this.metadataStatusRepository.deleteAllById_MetadataId(id);
            this.xmlSerializer.delete(String.valueOf(id), ServiceContext.get());
            this.searchManager.delete(String.format("+id:%d", id));
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.datamanager", (Object)("Couldn't cleanup draft " + draft), (Throwable)e);
        }
    }
}

