/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ElementSetName;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.MissingParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.v1_1.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.opengis.filter.Filter;

public abstract class AbstractOperation {
    protected void checkService(Element request) throws MissingParameterValueEx, InvalidParameterValueEx {
        String service = request.getAttributeValue("service");
        if (StringUtils.isEmpty((String)service)) {
            throw new MissingParameterValueEx("service");
        }
        if (!service.equals("CSW") && !service.equals("http://www.opengis.net/cat/csw")) {
            throw new InvalidParameterValueEx("service", service);
        }
    }

    protected void checkVersion(Element request) throws MissingParameterValueEx, InvalidParameterValueEx {
        String version = request.getAttributeValue("version");
        if (StringUtils.isEmpty((String)version)) {
            throw new MissingParameterValueEx("version");
        }
        if (!version.equals("2.0.2")) {
            throw new InvalidParameterValueEx("version", version);
        }
    }

    protected void setAttrib(Element elem, String name, String value) {
        if (value != null) {
            elem.setAttribute(name, value);
        }
    }

    protected void addElement(Element parent, String name, String value) {
        if (value != null) {
            Element elem = new Element(name, parent.getNamespace());
            elem.setText(value);
            parent.addContent((Content)elem);
        }
    }

    protected void fill(Element root, String parentName, String childName, String list, Namespace ns) {
        if (list == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        Element parent = new Element(parentName, ns);
        root.addContent((Content)parent);
        while (st.hasMoreTokens()) {
            Element child = new Element(childName, ns);
            child.setText(st.nextToken());
            parent.addContent((Content)child);
        }
    }

    protected void fill(Element root, String childName, String list) {
        if (list == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            Element child = new Element(childName, root.getNamespace());
            child.setText(st.nextToken());
            root.addContent((Content)child);
        }
    }

    protected ElementSetName getElementSetName(Element parent, ElementSetName defValue) throws InvalidParameterValueEx {
        if (parent == null) {
            return defValue;
        }
        return ElementSetName.parse(parent.getChildText("ElementSetName", parent.getNamespace()));
    }

    protected Map<String, String> retrieveNamespaces(String namespaces) {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (namespaces != null) {
            StringTokenizer st = new StringTokenizer(namespaces, ",");
            while (st.hasMoreTokens()) {
                String ns = st.nextToken();
                int pos = ns.indexOf(58);
                if (pos == -1) {
                    hm.put("", ns);
                    continue;
                }
                String prefix = ns.substring(0, pos);
                String uri = ns.substring(pos + 1);
                hm.put(prefix, uri);
            }
        }
        return hm;
    }

    protected Map<String, String> retrieveTypeNames(String typeNames, String namespace) throws InvalidParameterValueEx {
        HashMap<String, String> hmTypeNames = new HashMap<String, String>();
        Map<String, String> hmNamespaces = this.retrieveNamespaces(namespace);
        if (typeNames != null) {
            StringTokenizer st = new StringTokenizer(typeNames, ",");
            while (st.hasMoreTokens()) {
                String ns;
                String typeName = st.nextToken();
                int pos = typeName.indexOf(58);
                String prefix = "";
                if (pos != -1) {
                    prefix = typeName.substring(0, pos);
                }
                if ((ns = hmNamespaces.get(prefix)) == null) {
                    throw new InvalidParameterValueEx("typeName", "Can't find a valid namespace for typename " + typeName + ". Check namespace parameter.");
                }
                hmTypeNames.put(typeName, ns);
            }
        }
        return hmTypeNames;
    }

    protected List<Element> createValuesElement(Collection<String> param) {
        ArrayList<Element> values = new ArrayList<Element>();
        for (String value : param) {
            values.add(new Element("Value", Csw.NAMESPACE_CSW).setText(value));
        }
        return values;
    }

    protected List<Element> createValuesElementNS(Collection<Namespace> param) {
        ArrayList<Element> values = new ArrayList<Element>();
        for (Namespace ns : param) {
            String value = ns.getURI();
            values.add(new Element("Value", Csw.NAMESPACE_CSW).setText(value));
        }
        return values;
    }

    protected Element getFilterExpression(Element constr) throws CatalogException {
        if (constr == null) {
            return null;
        }
        Element filter = constr.getChild("Filter", Csw.NAMESPACE_OGC);
        Element cql = constr.getChild("CqlText", Csw.NAMESPACE_CSW);
        if (filter != null) {
            return filter;
        }
        if (cql != null) {
            return this.convertCQL(cql.getText());
        }
        return null;
    }

    private Element convertCQL(String cql) throws CatalogException {
        Element xmlFilter;
        String xml;
        Filter filter;
        if (Log.isDebugEnabled((String)"geonetwork.csw")) {
            Log.debug((String)"geonetwork.csw", (Object)("Received CQL:\n" + cql));
        }
        try {
            filter = CQL.toFilter((String)cql);
        }
        catch (CQLException e) {
            Log.error((String)"geonetwork.csw", (Object)"Error parsing CQL or during conversion into Filter");
            throw new NoApplicableCodeEx("Error during CQL to Filter conversion : " + (Object)((Object)e));
        }
        OGCConfiguration filter110Config = new OGCConfiguration();
        Encoder encoder = new Encoder((Configuration)filter110Config);
        Charset charset = Charset.forName("UTF-16");
        encoder.setEncoding(charset);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            encoder.encode((Object)filter, OGC.Filter, (OutputStream)out);
            xml = new String(out.toByteArray(), charset.toString());
        }
        catch (IOException e) {
            Log.error((String)"geonetwork.csw", (Object)e.getMessage());
            throw new NoApplicableCodeEx("Error transforming Filter to XML" + e);
        }
        try {
            xmlFilter = Xml.loadString((String)xml, (boolean)false);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.csw", (Object)"Error loading xml filter as jdom Element ");
            throw new NoApplicableCodeEx("Error loading xml filter as jdom Element " + e);
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw")) {
            Log.debug((String)"geonetwork.csw", (Object)("Transformed CQL gives the following filter:\n" + Xml.getString((Element)xmlFilter)));
        }
        return xmlFilter;
    }

    protected String getFilterVersion(Element constr) throws CatalogException {
        if (constr == null) {
            return "1.1.0";
        }
        String version = constr.getAttributeValue("version");
        if (version == null) {
            throw new MissingParameterValueEx("CONSTRAINT_LANGUAGE_VERSION");
        }
        if (!version.equals("1.0.0") && !version.equals("1.1.0")) {
            throw new InvalidParameterValueEx("version", version + ". Supported versions are " + "1.0.0" + "," + "1.1.0" + ".");
        }
        return version;
    }
}

