/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.fao.geonet.languages.IsoLanguagesMapper;

public class LanguageUtils {
    private final Set<String> iso3code;
    private final String defaultLanguage;
    Collection<Locale> locales = new ArrayList<Locale>();

    public LanguageUtils(Set<String> localesToLoad, String defaultLanguage) {
        this.iso3code = Collections.unmodifiableSet(localesToLoad);
        this.defaultLanguage = defaultLanguage;
        for (String l : this.iso3code) {
            this.locales.add(Locale.forLanguageTag(l));
        }
    }

    public Locale parseAcceptLanguage(Enumeration<Locale> listOfLocales) {
        while (listOfLocales.hasMoreElements()) {
            Locale l = listOfLocales.nextElement();
            if (!this.iso3code.contains(IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)l.getISO3Language()))) continue;
            return l;
        }
        return Locale.forLanguageTag(this.defaultLanguage);
    }

    public String getIso3langCode(Enumeration<Locale> locales) {
        Locale l = this.parseAcceptLanguage(locales);
        return IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)l.getISO3Language());
    }

    public Locale parseAcceptLanguage(Locale locale) {
        Vector<Locale> locales = new Vector<Locale>();
        locales.add(locale);
        return this.parseAcceptLanguage(locales.elements());
    }
}

