/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import groovy.lang.Closure;
import groovy.util.slurpersupport.GPathResult;
import java.util.regex.Pattern;
import org.fao.geonet.api.records.formatters.groovy.Handler;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;

public class HandlerPathSelect
extends Handler {
    private final Pattern pathPattern;

    public HandlerPathSelect(Pattern pathPattern, int priority, Closure handler) {
        super(priority, handler);
        this.pathPattern = pathPattern;
    }

    @Override
    public boolean select(TransformationContext context, GPathResult element) {
        StringBuilder path = new StringBuilder(context.getRootPath());
        if (path.length() > 0) {
            path.append(">");
        }
        HandlerPathSelect.createPath(element, path);
        return this.pathPattern.matcher(path.toString()).matches();
    }

    @Override
    protected String handlerExtraToString() {
        return ", pathPattern ~= /" + this.pathPattern + "/";
    }
}

