/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.AssociatedRecord;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="associatedRecords")
@ReadWriteController
public class MetadataAssociatedApi {
    @Autowired
    SchemaManager _schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    private ApplicationContext context;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Operation(summary="Get record associated resources", description="Retrieve related services, datasets, sources, ... to this records.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/index.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid:.+}/associated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the associated resources."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Map<RelatedItemType, List<AssociatedRecord>> getAssociatedResources(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Type of related resource. If none, all resources are returned.", required=false) @RequestParam(defaultValue="") RelatedItemType[] type, @Parameter(description="Start offset for paging. Default 1. Only applies to related metadata records (ie. not for thumbnails).", required=false) @RequestParam(defaultValue="0") int start, @Parameter(description="Number of rows returned. Default 100.") @RequestParam(defaultValue="100") int rows, HttpServletRequest request) throws Exception {
        AbstractMetadata md;
        try {
            md = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        String language = this.languageUtils.getIso3langCode(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (type.length == 0) {
            type = RelatedItemType.values();
        }
        return MetadataUtils.getAssociated(context, md, type, start, start + rows);
    }
}

