/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.fao.geonet.Constants;

public class StringBufferOutputStream
extends OutputStream {
    private StringBuffer strBuffer;
    private boolean closed = false;

    public StringBufferOutputStream(StringBuffer strBuffer) {
        this.strBuffer = strBuffer;
    }

    @Override
    public void write(int i) throws IOException {
        if (this.closed) {
            return;
        }
        this.strBuffer.append((char)i);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.closed) {
            return;
        }
        if (b == null) {
            throw new NullPointerException("The byte array is null");
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("offset and length are negative or extend outside array bounds");
        }
        String str = new String(b, offset, length, Charset.forName(Constants.ENCODING));
        this.strBuffer.append(str);
    }

    @Override
    public void close() {
        this.strBuffer = null;
        this.closed = true;
    }
}

