/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.TextSymbolizer;
import org.locationtech.jts.geom.Geometry;

public class LabelCacheItem
implements Comparable<LabelCacheItem> {
    TextStyle2D textStyle;
    List<Geometry> geoms = new ArrayList<Geometry>();
    double priority = 0.0;
    int spaceAround = 0;
    String label;
    private Set<String> layerIds = new HashSet<String>();
    int maxDisplacement = 0;
    int[] displacementAngles;
    int minGroupDistance = 0;
    int repeat = 0;
    boolean labelAllGroup = false;
    boolean removeGroupOverlaps = false;
    boolean allowOverruns = true;
    boolean followLineEnabled = false;
    double maxAngleDelta;
    int autoWrap = 100;
    boolean forceLeftToRightEnabled = true;
    boolean conflictResolutionEnabled = true;
    double goodnessOfFit = 0.0;
    TextSymbolizer.PolygonAlignOptions polygonAlign = TextSymbolizer.PolygonAlignOptions.NONE;
    GraphicResize graphicsResize = GraphicResize.NONE;
    int[] graphicMargin = null;
    boolean textUnderlined = false;
    boolean textStrikethrough = false;
    double wordSpacing;
    TextSymbolizer symbolizer;
    int fontShrinkSizeMin;
    boolean partialsEnabled = false;
    TextSymbolizer.GraphicPlacement graphicPlacement;

    public double getGoodnessOfFit() {
        return this.goodnessOfFit;
    }

    public void setGoodnessOfFit(double goodnessOfFit) {
        this.goodnessOfFit = goodnessOfFit;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public int getSpaceAround() {
        return this.spaceAround;
    }

    public void setSpaceAround(int space) {
        this.spaceAround = space;
    }

    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double d) {
        this.priority = d;
    }

    public LabelCacheItem(String layerId, TextStyle2D textStyle, LiteShape2 shape, String label, TextSymbolizer symbolizer) {
        this.textStyle = textStyle;
        this.geoms.add(shape.getGeometry());
        this.label = label;
        this.layerIds.add(layerId);
        this.symbolizer = symbolizer;
    }

    LabelCacheItem(LabelCacheItem other) {
        this.textStyle = other.textStyle;
        this.label = other.label;
        this.layerIds.addAll(other.getLayerIds());
        this.geoms.addAll(other.geoms);
        this.symbolizer = other.symbolizer;
        this.priority = other.priority;
        this.spaceAround = other.spaceAround;
        this.label = other.label;
        this.maxDisplacement = other.maxDisplacement;
        this.minGroupDistance = other.minGroupDistance;
        this.repeat = other.repeat;
        this.labelAllGroup = other.labelAllGroup;
        this.removeGroupOverlaps = other.removeGroupOverlaps;
        this.allowOverruns = other.allowOverruns;
        this.followLineEnabled = other.followLineEnabled;
        this.maxAngleDelta = other.maxAngleDelta;
        this.autoWrap = other.autoWrap;
        this.forceLeftToRightEnabled = other.forceLeftToRightEnabled;
        this.conflictResolutionEnabled = other.conflictResolutionEnabled;
        this.goodnessOfFit = other.goodnessOfFit;
        this.polygonAlign = other.polygonAlign;
        this.graphicsResize = other.graphicsResize;
        this.graphicMargin = other.graphicMargin;
        this.textUnderlined = other.textUnderlined;
        this.symbolizer = other.symbolizer;
        this.fontShrinkSizeMin = other.fontShrinkSizeMin;
    }

    public Set<String> getLayerIds() {
        return Collections.synchronizedSet(this.layerIds);
    }

    public List<Geometry> getGeoms() {
        return this.geoms;
    }

    public TextStyle2D getTextStyle() {
        return this.textStyle;
    }

    void setTextStyle(TextStyle2D textStyle) {
        this.textStyle = textStyle;
    }

    public Geometry getGeometry() {
        return this.geoms.get(0);
    }

    public int getMaxDisplacement() {
        return this.maxDisplacement;
    }

    public void setMaxDisplacement(int maxDisplacement) {
        this.maxDisplacement = maxDisplacement;
    }

    public int[] getDisplacementAngles() {
        return this.displacementAngles;
    }

    public void setDisplacementAngles(int[] displacementAngles) {
        this.displacementAngles = displacementAngles;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public boolean labelAllGroup() {
        return this.labelAllGroup;
    }

    public void setLabelAllGroup(boolean labelAllGroup) {
        this.labelAllGroup = labelAllGroup;
    }

    public boolean removeGroupOverlaps() {
        return this.removeGroupOverlaps;
    }

    public void setRemoveGroupOverlaps(boolean removeGroupOverlaps) {
        this.removeGroupOverlaps = removeGroupOverlaps;
    }

    public boolean allowOverruns() {
        return this.allowOverruns;
    }

    public void setAllowOverruns(boolean allowOverruns) {
        this.allowOverruns = allowOverruns;
    }

    public int getMinGroupDistance() {
        return this.minGroupDistance;
    }

    public void setMinGroupDistance(int minGroupDistance) {
        this.minGroupDistance = minGroupDistance;
    }

    public boolean isFollowLineEnabled() {
        return this.followLineEnabled;
    }

    public void setFollowLineEnabled(boolean followLineEnabled) {
        this.followLineEnabled = followLineEnabled;
    }

    public double getMaxAngleDelta() {
        return this.maxAngleDelta;
    }

    public void setMaxAngleDelta(double maxAngleDelta) {
        this.maxAngleDelta = maxAngleDelta;
    }

    public int getAutoWrap() {
        return this.autoWrap;
    }

    public void setAutoWrap(int autoWrap) {
        this.autoWrap = autoWrap;
    }

    @Override
    public int compareTo(LabelCacheItem other) {
        return Double.compare(this.getPriority(), other.getPriority());
    }

    public boolean isForceLeftToRightEnabled() {
        return this.forceLeftToRightEnabled;
    }

    public void setForceLeftToRightEnabled(boolean forceLeftToRight) {
        this.forceLeftToRightEnabled = forceLeftToRight;
    }

    public boolean isConflictResolutionEnabled() {
        return this.conflictResolutionEnabled;
    }

    public void setConflictResolutionEnabled(boolean conflictResolutionEnabled) {
        this.conflictResolutionEnabled = conflictResolutionEnabled;
    }

    public GraphicResize getGraphicsResize() {
        return this.graphicsResize;
    }

    public void setGraphicsResize(GraphicResize graphicsResize) {
        this.graphicsResize = graphicsResize;
    }

    public int[] getGraphicMargin() {
        return this.graphicMargin;
    }

    public void setGraphicMargin(int[] graphicMargin) {
        this.graphicMargin = graphicMargin;
    }

    void setPolygonAlign(TextSymbolizer.PolygonAlignOptions polygonAlign) {
        this.polygonAlign = polygonAlign;
    }

    TextSymbolizer.PolygonAlignOptions getPolygonAlign() {
        return this.polygonAlign;
    }

    public boolean isPartialsEnabled() {
        return this.partialsEnabled;
    }

    public void setPartialsEnabled(boolean partialsEnabled) {
        this.partialsEnabled = partialsEnabled;
    }

    public boolean isTextUnderlined() {
        return this.textUnderlined;
    }

    public void setTextUnderlined(boolean textUnderlined) {
        this.textUnderlined = textUnderlined;
    }

    public boolean isTextStrikethrough() {
        return this.textStrikethrough;
    }

    public void setTextStrikethrough(boolean textStrikethrough) {
        this.textStrikethrough = textStrikethrough;
    }

    public double getWordSpacing() {
        return this.wordSpacing;
    }

    public void setWordSpacing(double wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public int getFontShrinkSizeMin() {
        return this.fontShrinkSizeMin;
    }

    public void setFontShrinkSizeMin(int fontShrinkSize) {
        this.fontShrinkSizeMin = fontShrinkSize;
    }

    public TextSymbolizer.GraphicPlacement getGraphicPlacement() {
        return this.graphicPlacement == null ? TextSymbolizer.GraphicPlacement.LABEL : this.graphicPlacement;
    }

    public void setGraphicPlacement(TextSymbolizer.GraphicPlacement graphicPlacement) {
        this.graphicPlacement = graphicPlacement;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.symbolizer == null ? 0 : System.identityHashCode(this.symbolizer));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelCacheItem other = (LabelCacheItem)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return this.symbolizer == other.symbolizer;
    }

    public static enum GraphicResize {
        NONE,
        STRETCH,
        PROPORTIONAL;

    }
}

