/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetComposableIndexTemplatesResponse {
    public static final ParseField NAME = new ParseField("name", new String[0]);
    public static final ParseField INDEX_TEMPLATES = new ParseField("index_templates", new String[0]);
    public static final ParseField INDEX_TEMPLATE = new ParseField("index_template", new String[0]);
    private static final ConstructingObjectParser<Map<String, ComposableIndexTemplate>, Void> PARSER = new ConstructingObjectParser("index_templates", false, a -> ((List)a[0]).stream().collect(Collectors.toMap(n -> n.name, n -> n.indexTemplate, (n1, n2) -> n1, LinkedHashMap::new)));
    private static final ConstructingObjectParser<NamedIndexTemplate, Void> INNER_PARSER = new ConstructingObjectParser("named_index_template", false, a -> new NamedIndexTemplate((String)a[0], (ComposableIndexTemplate)a[1]));
    private final Map<String, ComposableIndexTemplate> indexTemplates;

    public String toString() {
        return "GetIndexTemplatesResponse [indexTemplates=" + this.indexTemplates + "]";
    }

    GetComposableIndexTemplatesResponse(Map<String, ComposableIndexTemplate> indexTemplates) {
        this.indexTemplates = Collections.unmodifiableMap(new LinkedHashMap<String, ComposableIndexTemplate>(indexTemplates));
    }

    public Map<String, ComposableIndexTemplate> getIndexTemplates() {
        return this.indexTemplates;
    }

    public static GetComposableIndexTemplatesResponse fromXContent(XContentParser parser) throws IOException {
        return new GetComposableIndexTemplatesResponse((Map)PARSER.apply(parser, null));
    }

    public int hashCode() {
        return Objects.hash(this.indexTemplates);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetComposableIndexTemplatesResponse other = (GetComposableIndexTemplatesResponse)obj;
        return Objects.equals(this.indexTemplates, other.indexTemplates);
    }

    static {
        INNER_PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        INNER_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)ComposableIndexTemplate.PARSER, INDEX_TEMPLATE);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), INNER_PARSER, INDEX_TEMPLATES);
    }

    private static class NamedIndexTemplate {
        String name;
        ComposableIndexTemplate indexTemplate;

        private NamedIndexTemplate(String name, ComposableIndexTemplate indexTemplate) {
            this.name = name;
            this.indexTemplate = indexTemplate;
        }
    }
}

