/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.security.web.csrf;

import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GeonetworkCsrfSecurityRequestMatcher
implements RequestMatcher {
    private Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private RegexRequestMatcher unprotectedMatcher;

    public GeonetworkCsrfSecurityRequestMatcher(Set<String> unprotectedUrlPatterns) {
        this.unprotectedMatcher = new RegexRequestMatcher(String.join((CharSequence)"|", unprotectedUrlPatterns), null);
    }

    public boolean matches(HttpServletRequest request) {
        if (this.allowedMethods.matcher(request.getMethod()).matches()) {
            return false;
        }
        return !this.unprotectedMatcher.matches(request);
    }
}

