/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import jeeves.server.context.ServiceContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.XmlRequest;

public class NetLib {
    public void setupProxy(ServiceContext context, XmlRequest req) {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = gc.getBean(SettingManager.class);
        this.setupProxy(sm, req);
    }

    public void setupProxy(SettingManager sm, XmlRequest req) {
        boolean enabled = sm.getValueAsBool("system/proxy/use", false);
        String host = sm.getValue("system/proxy/host");
        String port = sm.getValue("system/proxy/port");
        String username = sm.getValue("system/proxy/username");
        String password = sm.getValue("system/proxy/password");
        String ignoreHostList = sm.getValue("system/proxy/ignorehostlist");
        if (!enabled) {
            req.setUseProxy(false);
        } else if (!Lib.type.isInteger(port)) {
            Log.error((String)"geonetwork", (Object)("Proxy port is not an integer : " + port));
        } else if (!this.isProxyHostException(req.getHost(), ignoreHostList)) {
            req.setUseProxy(true);
            req.setProxyHost(host);
            req.setProxyPort(Integer.parseInt(port));
            if (username.trim().length() != 0) {
                req.setProxyCredentials(username, password);
            }
        } else {
            Log.info((String)"geonetwork", (Object)("Proxy configuration ignored, host: " + req.getHost() + " is in proxy ignore list"));
            req.setUseProxy(false);
        }
    }

    public CredentialsProvider setupProxy(ServiceContext context, HttpClientBuilder client, String requestHost) {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = gc.getBean(SettingManager.class);
        return this.setupProxy(sm, client, requestHost);
    }

    public CredentialsProvider setupProxy(SettingManager sm, HttpClientBuilder client, String requestHost) {
        boolean enabled = sm.getValueAsBool("system/proxy/use", false);
        String host = sm.getValue("system/proxy/host");
        String port = sm.getValue("system/proxy/port");
        String username = sm.getValue("system/proxy/username");
        String password = sm.getValue("system/proxy/password");
        String ignoreHostList = sm.getValue("system/proxy/ignorehostlist");
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (enabled) {
            if (!Lib.type.isInteger(port)) {
                Log.error((String)"geonetwork", (Object)("Proxy port is not an integer : " + port));
            } else if (!this.isProxyHostException(requestHost, ignoreHostList)) {
                HttpHost proxy = new HttpHost(host, Integer.parseInt(port));
                client.setProxy(proxy);
                if (username.trim().length() != 0) {
                    provider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(username, password));
                    client.setDefaultCredentialsProvider((CredentialsProvider)provider);
                }
            } else {
                client.setProxy(null);
            }
        }
        return provider;
    }

    public void setupProxy(ServiceContext context) {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = gc.getBean(SettingManager.class);
        this.setupProxy(sm);
    }

    public void setupProxy(SettingManager sm) {
        boolean useProxy = sm.getValueAsBool("system/proxy/use", false);
        if (useProxy) {
            String host = sm.getValue("system/proxy/host");
            String port = sm.getValue("system/proxy/port");
            String username = sm.getValue("system/proxy/username");
            String ignoreHostList = sm.getValue("system/proxy/ignorehostlist");
            Properties props = System.getProperties();
            props.put("http.proxyHost", host);
            props.put("http.proxyPort", port);
            props.put("http.nonProxyHosts", ignoreHostList);
            if (username.trim().length() > 0) {
                Log.error((String)"geonetwork", (Object)"Proxy credentials cannot be used");
            }
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.nonProxyHosts");
        }
    }

    public URLConnection setupProxy(ServiceContext context, URL url) throws IOException {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = gc.getBean(SettingManager.class);
        boolean enabled = sm.getValueAsBool("system/proxy/use", false);
        String host = sm.getValue("system/proxy/host");
        String port = sm.getValue("system/proxy/port");
        String username = sm.getValue("system/proxy/username");
        String password = sm.getValue("system/proxy/password");
        String ignoreHostList = sm.getValue("system/proxy/ignorehostlist");
        URLConnection conn = null;
        if (enabled) {
            if (!Lib.type.isInteger(port)) {
                Log.error((String)"geonetwork", (Object)("Proxy port is not an integer : " + port));
            } else if (!this.isProxyHostException(url.getHost(), ignoreHostList)) {
                InetSocketAddress sa = new InetSocketAddress(host, Integer.parseInt(port));
                Proxy proxy = new Proxy(Proxy.Type.HTTP, sa);
                conn = url.openConnection(proxy);
                if (username.trim().length() != 0) {
                    String encodedUserPwd = new Base64().encodeAsString((username + ":" + password).getBytes(Charset.forName("UTF-8")));
                    conn.setRequestProperty("Accept-Charset", "UTF-8");
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
                }
            } else {
                conn = url.openConnection();
            }
        } else {
            conn = url.openConnection();
        }
        return conn;
    }

    public boolean isUrlValid(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public boolean isProxyHostException(String requestHost, String ignoreHostList) {
        if (StringUtils.isEmpty((String)requestHost)) {
            return false;
        }
        if (StringUtils.isEmpty((String)ignoreHostList)) {
            return false;
        }
        try {
            return requestHost.matches(ignoreHostList);
        }
        catch (PatternSyntaxException ex) {
            Log.error((String)"geonetwork.httpproxy", (Object)("Proxy ignore host list expression is not valid: " + ex.getMessage()));
            return false;
        }
    }
}

