/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class MEFVisitor
implements IVisitor {
    @Override
    public void visit(Path mefFile, IMEFVisitor v) throws Exception {
        Element info = this.handleXml(mefFile, v);
        this.handleBin(mefFile, v, info, 0);
    }

    @Override
    public Element handleXml(Path mefFile, IMEFVisitor v) throws Exception {
        Element md = null;
        Element info = null;
        try (FileSystem zipFs = ZipUtil.openZipFs((Path)mefFile);){
            Path fileMdFile = zipFs.getPath("metadata.xml", new String[0]);
            Path infoMdFile = zipFs.getPath("info.xml", new String[0]);
            if (Files.exists(fileMdFile, new LinkOption[0])) {
                md = Xml.loadFile((Path)fileMdFile);
            }
            if (Files.exists(infoMdFile, new LinkOption[0])) {
                info = Xml.loadFile((Path)infoMdFile);
            }
        }
        if (md == null) {
            throw new BadFormatEx("Missing metadata file : metadata.xml");
        }
        if (info == null) {
            throw new BadFormatEx("Missing info file : info.xml");
        }
        v.handleMetadata(md, 0);
        v.handleInfo(info, 0);
        return info;
    }

    @Override
    public void handleBin(Path mefFile, IMEFVisitor v, Element info, int index) throws Exception {
        block64: {
            ArrayList<Element> prvFiles;
            ArrayList<Element> pubFiles;
            if (info.getChild("public") != null) {
                List tmp = info.getChild("public").getChildren();
                pubFiles = tmp;
            } else {
                pubFiles = new ArrayList();
            }
            if (info.getChild("private") != null) {
                List tmp = info.getChild("private").getChildren();
                prvFiles = tmp;
            } else {
                prvFiles = new ArrayList();
            }
            try (FileSystem zipFs = ZipUtil.openZipFs((Path)mefFile);){
                Path priPath;
                Path pubPath = zipFs.getPath("public/", new String[0]);
                if (Files.isDirectory(pubPath, new LinkOption[0])) {
                    try (DirectoryStream<Path> paths = Files.newDirectoryStream(pubPath);){
                        for (Path path : paths) {
                            String simpleName = path.getFileName().toString();
                            InputStream isb = IO.newInputStream((Path)path);
                            Throwable throwable = null;
                            try {
                                v.handlePublicFile(simpleName, MEFLib.getChangeDate(pubFiles, simpleName), isb, 0);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (isb == null) continue;
                                if (throwable != null) {
                                    try {
                                        isb.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                isb.close();
                            }
                        }
                    }
                }
                if (!Files.isDirectory(priPath = zipFs.getPath("private/", new String[0]), new LinkOption[0])) break block64;
                DirectoryStream<Path> paths = Files.newDirectoryStream(priPath);
                Object object = null;
                try {
                    for (Path path : paths) {
                        String simpleName = path.getFileName().toString();
                        InputStream isb = IO.newInputStream((Path)path);
                        Throwable throwable = null;
                        try {
                            v.handlePrivateFile(simpleName, MEFLib.getChangeDate(prvFiles, simpleName), isb, 0);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (isb == null) continue;
                            if (throwable != null) {
                                try {
                                    isb.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            isb.close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (paths != null) {
                        if (object != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            paths.close();
                        }
                    }
                }
            }
        }
    }
}

