/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class SelectionManager {
    public static final String SELECTION_METADATA = "metadata";
    public static final String SELECTION_BUCKET = "bucket";
    public static final int DEFAULT_MAXHITS = 1000;
    public static final String ADD_ALL_SELECTED = "add-all";
    public static final String REMOVE_ALL_SELECTED = "remove-all";
    public static final String ADD_SELECTED = "add";
    public static final String REMOVE_SELECTED = "remove";
    public static final String CLEAR_ADD_SELECTED = "clear-add";
    private Hashtable<String, Set<String>> selections = new Hashtable(0);

    private SelectionManager() {
        Set MDSelection = Collections.synchronizedSet(new HashSet(0));
        this.selections.put(SELECTION_METADATA, MDSelection);
    }

    public static void updateMDResult(UserSession session, Element result) {
        SelectionManager.updateMDResult(session, result, SELECTION_METADATA);
    }

    public static void updateMDResult(UserSession session, Element result, String bucket) {
        SelectionManager manager = SelectionManager.getManager(session);
        List elList = result.getChildren();
        Set<String> selection = manager.getSelection(bucket);
        for (Element element : elList) {
            if (element.getName().equals("summary")) continue;
            Element info = element.getChild("info", Edit.NAMESPACE);
            String uuid = info.getChildText("uuid");
            if (selection.contains(uuid)) {
                info.addContent((Content)new Element("selected").setText("true"));
                continue;
            }
            info.addContent((Content)new Element("selected").setText("false"));
        }
        result.setAttribute("selected", selection == null ? "0" : Integer.toString(selection.size()));
    }

    public static int updateSelection(String type, UserSession session, Element params, ServiceContext context) {
        List listOfIdentifiersElement = params.getChildren("id");
        ArrayList<String> listOfIdentifiers = new ArrayList<String>(listOfIdentifiersElement.size());
        for (Element e : listOfIdentifiersElement) {
            listOfIdentifiers.add(e.getText());
        }
        String selected = params.getChildText("selected");
        SelectionManager manager = SelectionManager.getManager(session);
        return manager.updateSelection(type, context, selected, listOfIdentifiers, session);
    }

    public static int updateSelection(String type, UserSession session, String actionOnSelection, List<String> listOfIdentifiers, ServiceContext context) {
        SelectionManager manager = SelectionManager.getManager(session);
        return manager.updateSelection(type, context, actionOnSelection, listOfIdentifiers, session);
    }

    @Nonnull
    public static SelectionManager getManager(UserSession session) {
        SelectionManager manager = (SelectionManager)session.getProperty("selected.result");
        if (manager == null) {
            manager = new SelectionManager();
            session.setProperty("selected.result", manager);
        }
        return manager;
    }

    public int updateSelection(String type, ServiceContext context, String selected, List<String> listOfIdentifiers, UserSession session) {
        Set<String> selection = this.getSelection(type);
        if (selection == null) {
            selection = Collections.synchronizedSet(new HashSet());
            this.selections.put(type, selection);
        }
        if (selected != null) {
            if (selected.equals(ADD_ALL_SELECTED)) {
                this.selectAll(type, context, session);
            } else if (selected.equals(REMOVE_ALL_SELECTED)) {
                this.close(type);
            } else if (selected.equals(ADD_SELECTED) && listOfIdentifiers.size() > 0) {
                for (String paramid : listOfIdentifiers) {
                    selection.add(paramid);
                }
            } else if (selected.equals(REMOVE_SELECTED) && listOfIdentifiers.size() > 0) {
                for (String paramid : listOfIdentifiers) {
                    selection.remove(paramid);
                }
            } else if (selected.equals(CLEAR_ADD_SELECTED) && listOfIdentifiers.size() > 0) {
                this.close(type);
                for (String paramid : listOfIdentifiers) {
                    selection.add(paramid);
                }
            }
        }
        Iterator<String> iter = selection.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            if (element != null) continue;
            iter.remove();
        }
        return selection.size();
    }

    public void selectAll(String type, ServiceContext context, UserSession session) {
        Set<String> selection = this.selections.get(type);
        int maxhits = 1000;
        SettingInfo settingInfo = (SettingInfo)ApplicationContextHolder.get().getBean(SettingInfo.class);
        try {
            maxhits = Integer.parseInt(settingInfo.getSelectionMaxRecords());
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("Select all - invalid max hits value, error: " + e.getMessage()), (Throwable)e);
        }
        if (selection != null) {
            selection.clear();
        }
        if (StringUtils.isNotEmpty((String)type)) {
            JsonNode request = (JsonNode)session.getProperty("search.request" + type);
            if (request == null) {
                return;
            }
            try {
                EsSearchManager searchManager = context.getBean(EsSearchManager.class);
                SearchResponse searchResponse = searchManager.query(request.get("query"), EsSearchManager.FIELDLIST_UUID, 0, maxhits);
                ArrayList<String> uuidList = new ArrayList<String>();
                for (SearchHit h : Arrays.asList(searchResponse.getHits().getHits())) {
                    uuidList.add((String)h.getSourceAsMap().get("uuid"));
                }
                if (selection != null) {
                    selection.addAll(uuidList);
                }
            }
            catch (Exception e) {
                Log.error((String)"geonetwork", (Object)("Select all - query error: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void close(String type) {
        Set<String> selection = this.selections.get(type);
        if (selection != null) {
            selection.clear();
        }
    }

    public void close() {
        for (Set<String> selection : this.selections.values()) {
            selection.clear();
        }
    }

    public Set<String> getSelection(String type) {
        Set<String> sel = this.selections.get(type);
        if (sel == null) {
            Set MDSelection = Collections.synchronizedSet(new HashSet(0));
            this.selections.put(type, MDSelection);
        }
        return this.selections.get(type);
    }

    public boolean addSelection(String type, String uuid) {
        return this.selections.get(type).add(uuid);
    }

    public boolean addAllSelection(String type, Set<String> uuids) {
        return this.selections.get(type).addAll(uuids);
    }
}

