/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.GeometryBuilder;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.aggregate.AggregateFactory;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;

public class WKTParser {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private GeometryFactory geometryFactory;
    private PrimitiveFactory primitiveFactory;
    private PositionFactory positionFactory;

    public WKTParser(GeometryBuilder builder) {
        this(builder.getGeometryFactory(), builder.getPrimitiveFactory(), builder.getPositionFactory(), builder.getAggregateFactory());
    }

    public WKTParser(GeometryFactory geometryFactory, PrimitiveFactory primitiveFactory, PositionFactory positionFactory, AggregateFactory aggregateFactory) {
        this.geometryFactory = geometryFactory;
        this.primitiveFactory = primitiveFactory;
        this.positionFactory = positionFactory;
    }

    public void setFactory(GeometryFactory factory) {
        this.geometryFactory = factory;
    }

    public void setFactory(PrimitiveFactory factory) {
        this.primitiveFactory = factory;
    }

    public void setFactory(PositionFactory factory) {
        this.positionFactory = factory;
    }

    public Geometry parse(String text) throws ParseException {
        return this.read(new StringReader(text));
    }

    public Geometry read(Reader reader) throws ParseException {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        this.setUpTokenizer(tokenizer);
        try {
            return this.readGeometryTaggedText(tokenizer);
        }
        catch (IOException e) {
            throw new ParseException(e.toString(), tokenizer.lineno());
        }
    }

    private void setUpTokenizer(StreamTokenizer tokenizer) {
        int char128 = 128;
        int skip32 = 32;
        int char255 = 255;
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(43, 43);
        tokenizer.wordChars(46, 46);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.commentChar(35);
    }

    private Geometry readGeometryTaggedText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String type = this.getNextWord(tokenizer);
        if (type.equals("POINT")) {
            return this.readPointText(tokenizer);
        }
        if (type.equalsIgnoreCase("LINESTRING")) {
            return this.readLineStringText(tokenizer);
        }
        if (type.equalsIgnoreCase("LINEARRING")) {
            return this.readLinearRingText(tokenizer);
        }
        if (type.equalsIgnoreCase("POLYGON")) {
            return this.readPolygonText(tokenizer);
        }
        if (type.equalsIgnoreCase("MULTIPOINT")) {
            return this.readMultiPointText(tokenizer);
        }
        if (type.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.readMultiPolygonText(tokenizer);
        }
        if (type.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText(tokenizer);
        }
        if (type.equalsIgnoreCase("MULTILINESTRING")) {
            return this.readMultiLineStringText(tokenizer);
        }
        throw new ParseException("Unknown geometry type: " + type, tokenizer.lineno());
    }

    private List getCoordinates(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        ArrayList<DirectPosition> coordinates = new ArrayList<DirectPosition>();
        if (!nextToken.equals(EMPTY)) {
            coordinates.add(this.getPreciseCoordinate(tokenizer));
            nextToken = this.getNextCloserOrComma(tokenizer);
            while (nextToken.equals(COMMA)) {
                coordinates.add(this.getPreciseCoordinate(tokenizer));
                nextToken = this.getNextCloserOrComma(tokenizer);
            }
        }
        return coordinates;
    }

    private DirectPosition getPreciseCoordinate(StreamTokenizer tokenizer) throws IOException, ParseException {
        DirectPosition pos = this.positionFactory.createDirectPosition();
        pos.setOrdinate(0, this.getNextNumber(tokenizer));
        pos.setOrdinate(1, this.getNextNumber(tokenizer));
        if (this.isNumberNext(tokenizer)) {
            pos.setOrdinate(1, this.getNextNumber(tokenizer));
        }
        return pos;
    }

    private boolean isNumberNext(StreamTokenizer tokenizer) throws IOException {
        int type = tokenizer.nextToken();
        tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber(StreamTokenizer tokenizer) throws IOException, ParseException {
        int type = tokenizer.nextToken();
        switch (type) {
            case -3: {
                try {
                    return Double.parseDouble(tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid number: " + tokenizer.sval, tokenizer.lineno());
                }
            }
        }
        this.parseError("number", tokenizer);
        return 0.0;
    }

    private String getNextEmptyOrOpener(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = this.getNextWord(tokenizer);
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseError("EMPTY or (", tokenizer);
        return null;
    }

    private String getNextCloserOrComma(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = this.getNextWord(tokenizer);
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(", or )", tokenizer);
        return null;
    }

    private String getNextCloser(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextWord = this.getNextWord(tokenizer);
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(R_PAREN, tokenizer);
        return null;
    }

    private String getNextWord(StreamTokenizer tokenizer) throws IOException, ParseException {
        String value;
        int type = tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    String string = EMPTY;
                }
                value = word;
                break;
            }
            case 40: {
                value = L_PAREN;
                break;
            }
            case 41: {
                value = R_PAREN;
                break;
            }
            case 44: {
                value = COMMA;
                break;
            }
            default: {
                this.parseError("word", tokenizer);
                value = null;
            }
        }
        return value;
    }

    private void parseError(String expected, StreamTokenizer tokenizer) throws ParseException {
        String tokenStr = this.tokenString(tokenizer);
        throw new ParseException("Expected " + expected + " but found " + tokenStr, 0);
    }

    private String tokenString(StreamTokenizer tokenizer) {
        switch (tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + tokenizer.sval + "'";
            }
        }
        return "'" + (char)tokenizer.ttype + "'";
    }

    private Point readPointText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals(EMPTY)) {
            return this.primitiveFactory.createPoint(new double[2]);
        }
        Point point = this.primitiveFactory.createPoint((Position)this.getPreciseCoordinate(tokenizer));
        this.getNextCloser(tokenizer);
        return point;
    }

    private Curve readLineStringText(StreamTokenizer tokenizer) throws IOException, ParseException {
        List coordList = this.getCoordinates(tokenizer);
        LineString lineString = this.geometryFactory.createLineString(coordList);
        List<LineString> curveSegmentList = Collections.singletonList(lineString);
        Curve curve = this.primitiveFactory.createCurve(curveSegmentList);
        return curve;
    }

    private Curve readLinearRingText(StreamTokenizer tokenizer) throws IOException, ParseException {
        List coordList = this.getCoordinates(tokenizer);
        LineString lineString = this.geometryFactory.createLineString(coordList);
        List<LineString> curveSegmentList = Collections.singletonList(lineString);
        Curve curve = this.primitiveFactory.createCurve(curveSegmentList);
        return curve;
    }

    private Surface readPolygonText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals(EMPTY)) {
            return null;
        }
        Curve curve = this.readLinearRingText(tokenizer);
        List<Curve> curveList = Collections.singletonList(curve);
        Ring shell = this.primitiveFactory.createRing(curveList);
        ArrayList<Ring> holes = new ArrayList<Ring>();
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            Curve holecurve = this.readLinearRingText(tokenizer);
            List<Curve> holeList = Collections.singletonList(holecurve);
            Ring hole = this.primitiveFactory.createRing(holeList);
            holes.add(hole);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        SurfaceBoundary sb = this.primitiveFactory.createSurfaceBoundary(shell, holes);
        return this.primitiveFactory.createSurface(sb);
    }

    private MultiPrimitive readMultiPolygonText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals(EMPTY)) {
            return null;
        }
        MultiPrimitive multi = this.geometryFactory.createMultiPrimitive();
        Surface surface = this.readPolygonText(tokenizer);
        Set elements = multi.getElements();
        elements.add(surface);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            surface = this.readPolygonText(tokenizer);
            elements.add(surface);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        return multi;
    }

    private MultiPrimitive readMultiPointText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals(EMPTY)) {
            return null;
        }
        MultiPrimitive multi = this.geometryFactory.createMultiPrimitive();
        Point point = this.primitiveFactory.createPoint((Position)this.getPreciseCoordinate(tokenizer));
        Set elements = multi.getElements();
        elements.add(point);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            point = this.primitiveFactory.createPoint((Position)this.getPreciseCoordinate(tokenizer));
            elements.add(point);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        return multi;
    }

    private MultiPrimitive readGeometryCollectionText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals(EMPTY)) {
            return null;
        }
        MultiPrimitive multi = this.geometryFactory.createMultiPrimitive();
        Geometry geom = this.readGeometryTaggedText(tokenizer);
        Set elements = multi.getElements();
        elements.add(geom);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            geom = this.readGeometryTaggedText(tokenizer);
            elements.add(geom);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        return multi;
    }

    private MultiPrimitive readMultiLineStringText(StreamTokenizer tokenizer) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener(tokenizer);
        if (nextToken.equals(EMPTY)) {
            return null;
        }
        MultiPrimitive multi = this.geometryFactory.createMultiPrimitive();
        Curve curve = this.readLineStringText(tokenizer);
        Set elements = multi.getElements();
        elements.add(curve);
        nextToken = this.getNextCloserOrComma(tokenizer);
        while (nextToken.equals(COMMA)) {
            curve = this.readLineStringText(tokenizer);
            elements.add(curve);
            nextToken = this.getNextCloserOrComma(tokenizer);
        }
        return multi;
    }
}

