/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.function.Classifier;

public final class RangedClassifier
extends Classifier {
    Comparable<?>[] min;
    Comparable<?>[] max;

    public RangedClassifier(Comparable[] min, Comparable[] max) {
        this.min = min;
        this.max = max;
        this.titles = new String[min.length];
        for (int i = 0; i < this.titles.length; ++i) {
            this.titles[i] = this.generateTitle(min[i], max[i]);
        }
    }

    private String generateTitle(Comparable<?> min, Comparable<?> max) {
        if (min == null && max == null) {
            return "Other";
        }
        if (min == null) {
            return "Below " + this.truncateZeros(String.valueOf(max));
        }
        if (max == null) {
            return "Above " + this.truncateZeros(String.valueOf(min));
        }
        return this.truncateZeros(String.valueOf(min)) + ".." + this.truncateZeros(String.valueOf(max));
    }

    private String truncateZeros(String str) {
        if (str.indexOf(".") > -1) {
            while (str.endsWith("0")) {
                str = str.substring(0, str.length() - 1);
            }
            if (str.endsWith(".")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    @Override
    public int getSize() {
        return Math.min(this.min.length, this.max.length);
    }

    public Object getMin(int slot) {
        return this.min[slot];
    }

    public Object getMax(int slot) {
        return this.max[slot];
    }

    @Override
    public int classify(Object value) {
        return this.classify((Comparable)value);
    }

    private int classify(Comparable<?> val) {
        Double value = val;
        if (val instanceof Integer) {
            value = (double)((Integer)((Object)val));
        }
        int last = this.min.length - 1;
        for (int i = 0; i <= last; ++i) {
            Comparable<?> localMin = this.min[i];
            Comparable<?> localMax = this.max[i];
            if (localMin != null && localMin.compareTo(value) >= 1 || localMax != null && localMax.compareTo(value) <= 0) continue;
            return i;
        }
        if (this.compareTo(this.max[last], value) == 0) {
            return last;
        }
        return -1;
    }

    private int compareTo(Comparable compare, Comparable value) {
        if (compare == null && value == null) {
            return 0;
        }
        if (compare == null) {
            return -1;
        }
        if (value == null) {
            return 1;
        }
        return value.compareTo(compare);
    }
}

