/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.DoubleCollection;
import bak.pcj.adapter.DoubleIteratorToIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class DoubleCollectionToCollectionAdapter
extends AbstractCollection {
    protected DoubleCollection collection;

    public DoubleCollectionToCollectionAdapter(DoubleCollection collection) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
    }

    public boolean add(Object o) {
        if (o == null) {
            Exceptions.nullElementNotAllowed();
        }
        return this.collection.add((Double)o);
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(Object o) {
        try {
            return this.collection.contains((Double)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public Iterator iterator() {
        return new DoubleIteratorToIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(Object o) {
        try {
            return this.collection.remove((Double)o);
        }
        catch (ClassCastException cce) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        return super.retainAll(c);
    }

    public int size() {
        return this.collection.size();
    }

    public int hashCode() {
        return this.collection.hashCode();
    }
}

