/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;

public class MetadataMappingService {
    private static final Logger logger = LogManager.getLogger(MetadataMappingService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    final PutMappingExecutor putMappingExecutor = new PutMappingExecutor();

    @Inject
    public MetadataMappingService(ClusterService clusterService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, final ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-mapping " + Strings.arrayToCommaDelimitedString(request.indices()), request, ClusterStateTaskConfig.build(Priority.HIGH, request.masterNodeTimeout()), this.putMappingExecutor, new AckedClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                listener.onResponse(AcknowledgedResponse.of(e == null));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(AcknowledgedResponse.FALSE);
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    class PutMappingExecutor
    implements ClusterStateTaskExecutor<PutMappingClusterStateUpdateRequest> {
        PutMappingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<PutMappingClusterStateUpdateRequest> execute(ClusterState currentState, List<PutMappingClusterStateUpdateRequest> tasks) throws Exception {
            HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<PutMappingClusterStateUpdateRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            try {
                for (PutMappingClusterStateUpdateRequest request : tasks) {
                    try {
                        for (Index index : request.indices()) {
                            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
                            if (indexMapperServices.containsKey(indexMetadata.getIndex())) continue;
                            MapperService mapperService = MetadataMappingService.this.indicesService.createIndexMapperService(indexMetadata);
                            indexMapperServices.put(index, mapperService);
                            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                        }
                        currentState = this.applyRequest(currentState, request, indexMapperServices);
                        builder.success(request);
                    }
                    catch (Exception e) {
                        builder.failure(request, e);
                    }
                }
                ClusterStateTaskExecutor.ClusterTasksResult clusterTasksResult = builder.build(currentState);
                return clusterTasksResult;
            }
            finally {
                IOUtils.close(indexMapperServices.values());
            }
        }

        private ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request, Map<Index, MapperService> indexMapperServices) throws IOException {
            String typeForUpdate;
            String mappingType = request.type();
            CompressedXContent mappingUpdateSource = new CompressedXContent(request.source());
            Metadata metadata = currentState.metadata();
            ArrayList<IndexMetadata> updateList = new ArrayList<IndexMetadata>();
            for (Index index : request.indices()) {
                Mapping newMapping;
                MapperService mapperService = indexMapperServices.get(index);
                IndexMetadata indexMetadata = currentState.getMetadata().getIndexSafe(index);
                updateList.add(indexMetadata);
                DocumentMapper existingMapper = mapperService.documentMapper();
                typeForUpdate = mapperService.getTypeForUpdate(mappingType, mappingUpdateSource);
                if (existingMapper != null && !existingMapper.type().equals(typeForUpdate)) {
                    throw new IllegalArgumentException("Rejecting mapping update to [" + mapperService.index().getName() + "] as the final mapping would have more than 1 type: " + Arrays.asList(existingMapper.type(), typeForUpdate));
                }
                if ("_default_".equals(request.type())) {
                    newMapping = mapperService.parseMapping(request.type(), mappingUpdateSource, false);
                } else {
                    Mapping mapping = mapperService.parseMapping(request.type(), mappingUpdateSource, existingMapper == null);
                    newMapping = MapperService.mergeMappings(existingMapper, mapping, MapperService.MergeReason.MAPPING_UPDATE);
                }
                if (mappingType == null) {
                    mappingType = newMapping.type();
                    continue;
                }
                if (mappingType.equals(newMapping.type()) || !MapperService.isMappingSourceTyped(request.type(), mappingUpdateSource) && mapperService.resolveDocumentType(mappingType).equals(newMapping.type())) continue;
                throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition.");
            }
            assert (mappingType != null);
            if (!"_default_".equals(mappingType) && !"_doc".equals(mappingType) && mappingType.charAt(0) == '_') {
                throw new InvalidTypeNameException("Document mapping type name can't start with '_', found: [" + mappingType + "]");
            }
            Metadata.Builder builder = Metadata.builder(metadata);
            boolean updated = false;
            for (IndexMetadata indexMetadata : updateList) {
                boolean updatedMapping = false;
                Index index = indexMetadata.getIndex();
                MapperService mapperService = indexMapperServices.get(index);
                typeForUpdate = mapperService.getTypeForUpdate(mappingType, mappingUpdateSource);
                CompressedXContent existingSource = null;
                DocumentMapper existingMapper = mapperService.documentMapper(typeForUpdate);
                if (existingMapper != null) {
                    existingSource = existingMapper.mappingSource();
                }
                DocumentMapper mergedMapper = mapperService.merge(typeForUpdate, mappingUpdateSource, MapperService.MergeReason.MAPPING_UPDATE);
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (existingSource != null) {
                    if (!existingSource.equals(updatedSource)) {
                        updatedMapping = true;
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} update_mapping [{}] with source [{}]", (Object)index, (Object)mergedMapper.type(), (Object)updatedSource);
                        } else if (logger.isInfoEnabled()) {
                            logger.info("{} update_mapping [{}]", (Object)index, (Object)mergedMapper.type());
                        }
                    }
                } else {
                    updatedMapping = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} create_mapping [{}] with source [{}]", (Object)index, (Object)mappingType, (Object)updatedSource);
                    } else if (logger.isInfoEnabled()) {
                        logger.info("{} create_mapping [{}]", (Object)index, (Object)mappingType);
                    }
                }
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
                for (DocumentMapper mapper : Arrays.asList(mapperService.documentMapper(), mapperService.documentMapper("_default_"))) {
                    if (mapper == null) continue;
                    indexMetadataBuilder.putMapping(new MappingMetadata(mapper.mappingSource()));
                }
                if (updatedMapping) {
                    indexMetadataBuilder.mappingVersion(1L + indexMetadataBuilder.mappingVersion());
                }
                builder.put(indexMetadataBuilder);
                updated |= updatedMapping;
            }
            if (updated) {
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }

        @Override
        public String describeTasks(List<PutMappingClusterStateUpdateRequest> tasks) {
            return String.join((CharSequence)", ", tasks.stream().map(t -> t.type())::iterator);
        }
    }
}

