/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class BroadcastRequest<Request extends BroadcastRequest<Request>>
extends ActionRequest
implements IndicesRequest.Replaceable {
    protected String[] indices;
    private IndicesOptions indicesOptions;
    @Nullable
    private TimeValue timeout;

    public BroadcastRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.timeout = in.getVersion().onOrAfter(Version.V_7_12_0) ? in.readOptionalTimeValue() : null;
    }

    protected BroadcastRequest(String ... indices) {
        this(indices, IndicesOptions.strictExpandOpenAndForbidClosed());
    }

    protected BroadcastRequest(String[] indices, IndicesOptions indicesOptions) {
        this(indices, indicesOptions, null);
    }

    protected BroadcastRequest(String[] indices, IndicesOptions indicesOptions, @Nullable TimeValue timeout) {
        this.indices = indices;
        this.indicesOptions = indicesOptions;
        this.timeout = timeout;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public final Request indices(String ... indices) {
        this.indices = indices;
        return (Request)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final Request indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (Request)this;
    }

    @Nullable
    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(@Nullable TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            out.writeOptionalTimeValue(this.timeout);
        }
    }
}

