/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.docker.domain.Config;
import org.jclouds.docker.internal.NullSafeCopies;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;

public class DockerTemplateOptions
extends TemplateOptions
implements Cloneable {
    private static final String NO_IMAGE = "jclouds-placeholder-for-image";
    protected List<String> dns = ImmutableList.of();
    @Nullable
    protected String hostname;
    @Nullable
    protected Integer memory;
    @Nullable
    protected Integer cpuShares;
    @Nullable
    List<String> entrypoint;
    @Nullable
    List<String> commands;
    protected Map<String, String> volumes = ImmutableMap.of();
    @Nullable
    protected List<String> env;
    protected Map<Integer, Integer> portBindings = ImmutableMap.of();
    @Nullable
    protected String networkMode;
    protected Map<String, String> extraHosts = ImmutableMap.of();
    protected List<String> volumesFrom = ImmutableList.of();
    protected boolean privileged;
    protected boolean openStdin;
    protected Config.Builder configBuilder;

    public DockerTemplateOptions clone() {
        DockerTemplateOptions options = new DockerTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof DockerTemplateOptions) {
            DockerTemplateOptions eTo = (DockerTemplateOptions)DockerTemplateOptions.class.cast(to);
            eTo.volumes(this.volumes);
            eTo.hostname(this.hostname);
            eTo.dns(this.dns);
            eTo.memory(this.memory);
            eTo.cpuShares(this.cpuShares);
            eTo.entrypoint(this.entrypoint);
            eTo.commands(this.commands);
            eTo.env(this.env);
            eTo.portBindings(this.portBindings);
            eTo.networkMode(this.networkMode);
            eTo.extraHosts(this.extraHosts);
            eTo.volumesFrom(this.volumesFrom);
            eTo.privileged(this.privileged);
            eTo.openStdin(this.openStdin);
            eTo.configBuilder(this.configBuilder);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerTemplateOptions that = (DockerTemplateOptions)DockerTemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal(this.volumes, that.volumes) && Objects.equal((Object)this.hostname, (Object)that.hostname) && Objects.equal(this.dns, that.dns) && Objects.equal((Object)this.memory, (Object)that.memory) && Objects.equal((Object)this.cpuShares, (Object)that.cpuShares) && Objects.equal(this.entrypoint, that.entrypoint) && Objects.equal(this.commands, that.commands) && Objects.equal(this.env, that.env) && Objects.equal(this.portBindings, that.portBindings) && Objects.equal((Object)this.networkMode, (Object)that.networkMode) && Objects.equal(this.extraHosts, that.extraHosts) && Objects.equal(this.volumesFrom, that.volumesFrom) && Objects.equal((Object)this.privileged, (Object)that.privileged) && Objects.equal((Object)this.openStdin, (Object)that.openStdin) && this.buildersEqual(this.configBuilder, that.configBuilder);
    }

    private boolean buildersEqual(Config.Builder b1, Config.Builder b2) {
        return b1 == b2 || b1 != null && b2 != null && b1.build().equals(b2.build());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.volumes, this.hostname, this.dns, this.memory, this.entrypoint, this.commands, this.cpuShares, this.env, this.portBindings, this.networkMode, this.extraHosts, this.volumesFrom, this.privileged, this.openStdin, this.configBuilder});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("volumes", this.volumes).add("hostname", (Object)this.hostname).add("dns", this.dns).add("memory", (Object)this.memory).add("cpuShares", (Object)this.cpuShares).add("entrypoint", this.entrypoint).add("commands", this.commands).add("env", this.env).add("portBindings", this.portBindings).add("networkMode", (Object)this.networkMode).add("extraHosts", this.extraHosts).add("volumesFrom", this.volumesFrom).add("privileged", this.privileged).add("openStdin", this.openStdin).add("configBuilder", (Object)this.configBuilder).toString();
    }

    public DockerTemplateOptions volumes(Map<String, String> volumes) {
        this.volumes = NullSafeCopies.copyOf(volumes);
        return this;
    }

    public DockerTemplateOptions dns(Iterable<String> dns) {
        this.dns = NullSafeCopies.copyOf(dns);
        return this;
    }

    public DockerTemplateOptions dns(String ... dns) {
        this.dns = NullSafeCopies.copyOf(dns);
        return this;
    }

    public DockerTemplateOptions hostname(@Nullable String hostname) {
        this.hostname = hostname;
        return this;
    }

    public DockerTemplateOptions memory(@Nullable Integer memory) {
        this.memory = memory;
        return this;
    }

    public DockerTemplateOptions entrypoint(Iterable<String> entrypoint) {
        this.entrypoint = NullSafeCopies.copyWithNullOf(entrypoint);
        return this;
    }

    public DockerTemplateOptions entrypoint(String ... entrypoint) {
        this.entrypoint = NullSafeCopies.copyWithNullOf(entrypoint);
        return this;
    }

    public DockerTemplateOptions commands(Iterable<String> commands) {
        this.commands = NullSafeCopies.copyWithNullOf(commands);
        return this;
    }

    public DockerTemplateOptions commands(String ... commands) {
        this.commands = NullSafeCopies.copyWithNullOf(commands);
        return this;
    }

    public DockerTemplateOptions cpuShares(@Nullable Integer cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    public DockerTemplateOptions env(Iterable<String> env) {
        this.env = NullSafeCopies.copyWithNullOf(env);
        return this;
    }

    public DockerTemplateOptions env(String ... env) {
        this.env = NullSafeCopies.copyWithNullOf(env);
        return this;
    }

    public DockerTemplateOptions portBindings(Map<Integer, Integer> portBindings) {
        this.portBindings = NullSafeCopies.copyOf(portBindings);
        return this;
    }

    public DockerTemplateOptions networkMode(@Nullable String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    public DockerTemplateOptions extraHosts(Map<String, String> extraHosts) {
        this.extraHosts = NullSafeCopies.copyOf(extraHosts);
        return this;
    }

    public DockerTemplateOptions volumesFrom(Iterable<String> volumesFrom) {
        this.volumesFrom = NullSafeCopies.copyOf(volumesFrom);
        return this;
    }

    public DockerTemplateOptions privileged(boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    public DockerTemplateOptions openStdin(boolean openStdin) {
        this.openStdin = openStdin;
        return this;
    }

    public DockerTemplateOptions configBuilder(Config.Builder configBuilder) {
        this.configBuilder = configBuilder != null ? Config.builder().fromConfig(configBuilder.image(NO_IMAGE).build()) : null;
        return this;
    }

    public Map<String, String> getVolumes() {
        return this.volumes;
    }

    public List<String> getDns() {
        return this.dns;
    }

    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public List<String> getEnv() {
        return this.env;
    }

    public Map<Integer, Integer> getPortBindings() {
        return this.portBindings;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public Map<String, String> getExtraHosts() {
        return this.extraHosts;
    }

    public boolean getPrivileged() {
        return this.privileged;
    }

    public boolean getOpenStdin() {
        return this.openStdin;
    }

    public Config.Builder getConfigBuilder() {
        return this.configBuilder;
    }

    public DockerTemplateOptions blockOnPort(int port, int seconds) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public DockerTemplateOptions inboundPorts(int ... ports) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public DockerTemplateOptions authorizePublicKey(String publicKey) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public DockerTemplateOptions installPrivateKey(String privateKey) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public DockerTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public DockerTemplateOptions dontAuthorizePublicKey() {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public DockerTemplateOptions nameTask(String name) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.nameTask(name));
    }

    public DockerTemplateOptions runAsRoot(boolean runAsRoot) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public DockerTemplateOptions runScript(Statement script) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.runScript(script));
    }

    public DockerTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public DockerTemplateOptions overrideLoginPassword(String password) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public DockerTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public DockerTemplateOptions overrideLoginUser(String loginUser) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public DockerTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public DockerTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public DockerTemplateOptions userMetadata(String key, String value) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public DockerTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public DockerTemplateOptions networks(Iterable<String> networks) {
        return (DockerTemplateOptions)DockerTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static DockerTemplateOptions volumes(Map<String, String> volumes) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.volumes(volumes);
        }

        public static DockerTemplateOptions dns(String ... dns) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.dns(dns);
        }

        public static DockerTemplateOptions dns(Iterable<String> dns) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.dns(dns);
        }

        public static DockerTemplateOptions hostname(@Nullable String hostname) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.hostname(hostname);
        }

        public static DockerTemplateOptions memory(@Nullable Integer memory) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.memory(memory);
        }

        public static DockerTemplateOptions entrypoint(String ... entrypoint) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.entrypoint(entrypoint);
        }

        public static DockerTemplateOptions entrypoint(Iterable<String> entrypoint) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.entrypoint(entrypoint);
        }

        public static DockerTemplateOptions commands(String ... commands) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.commands(commands);
        }

        public static DockerTemplateOptions commands(Iterable<String> commands) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.commands(commands);
        }

        public static DockerTemplateOptions cpuShares(@Nullable Integer cpuShares) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.cpuShares(cpuShares);
        }

        public static DockerTemplateOptions env(String ... env) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.env(env);
        }

        public static DockerTemplateOptions env(Iterable<String> env) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.env(env);
        }

        public static DockerTemplateOptions portBindings(Map<Integer, Integer> portBindings) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.portBindings(portBindings);
        }

        public static DockerTemplateOptions networkMode(@Nullable String networkMode) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.networkMode(networkMode);
        }

        public static DockerTemplateOptions extraHosts(Map<String, String> extraHosts) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.extraHosts(extraHosts);
        }

        public static DockerTemplateOptions privileged(boolean privileged) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.privileged(privileged);
        }

        public static DockerTemplateOptions openStdin(boolean openStdin) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.openStdin(openStdin);
        }

        public static DockerTemplateOptions configBuilder(Config.Builder configBuilder) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.configBuilder(configBuilder);
        }

        public static DockerTemplateOptions volumesFrom(Iterable<String> volumesFrom) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.volumesFrom(volumesFrom);
        }

        public static DockerTemplateOptions inboundPorts(int ... ports) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.inboundPorts(ports);
        }

        public static DockerTemplateOptions blockOnPort(int port, int seconds) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.blockOnPort(port, seconds);
        }

        public static DockerTemplateOptions installPrivateKey(String rsaKey) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.installPrivateKey(rsaKey);
        }

        public static DockerTemplateOptions authorizePublicKey(String rsaKey) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.authorizePublicKey(rsaKey);
        }

        public static DockerTemplateOptions userMetadata(Map<String, String> userMetadata) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.userMetadata((Map)userMetadata);
        }

        public static DockerTemplateOptions nodeNames(Iterable<String> nodeNames) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.nodeNames((Iterable)nodeNames);
        }

        public static DockerTemplateOptions networks(Iterable<String> networks) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.networks((Iterable)networks);
        }

        public static DockerTemplateOptions overrideLoginUser(String user) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static DockerTemplateOptions overrideLoginPassword(String password) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static DockerTemplateOptions overrideLoginPrivateKey(String privateKey) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static DockerTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static DockerTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static DockerTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            DockerTemplateOptions options = new DockerTemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }
    }
}

