/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rackspace.cloudloadbalancers.v1.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.v1.domain.LoadBalancerUsage;
import org.jclouds.rackspace.cloudloadbalancers.v1.features.ReportApi;

@Singleton
public class ParseLoadBalancerUsages
extends ParseJson<LoadBalancerUsages> {
    @Inject
    public ParseLoadBalancerUsages(Json json) {
        super(json, TypeLiteral.get(LoadBalancerUsages.class));
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<LoadBalancerUsage, ToPagedIterable> {
        private final CloudLoadBalancersApi api;

        @Inject
        protected ToPagedIterable(CloudLoadBalancersApi api) {
            this.api = (CloudLoadBalancersApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<LoadBalancerUsage>> markerToNextForArg0(Optional<Object> arg0) {
            String region = arg0.get().toString();
            final ReportApi reportApi = this.api.getReportApi(region);
            return new Function<Object, IterableWithMarker<LoadBalancerUsage>>(){

                public IterableWithMarker<LoadBalancerUsage> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    IterableWithMarker<LoadBalancerUsage> list = reportApi.listLoadBalancerUsage(paginationOptions);
                    return list;
                }

                public String toString() {
                    return "listLoadBalancerUsage()";
                }
            };
        }
    }

    static class LoadBalancerUsages
    extends PaginatedCollection<LoadBalancerUsage> {
        @ConstructorProperties(value={"loadBalancerUsageRecords", "links"})
        protected LoadBalancerUsages(Iterable<LoadBalancerUsage> loadBalancerUsageRecords, Iterable<Link> links) {
            super(loadBalancerUsageRecords, links);
        }
    }
}

