/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.strategy.ListCookbookVersionsInEnvironment;
import org.jclouds.chef.strategy.internal.BaseListCookbookVersionsImpl;
import org.jclouds.logging.Logger;

@Singleton
public class ListCookbookVersionsInEnvironmentImpl
extends BaseListCookbookVersionsImpl
implements ListCookbookVersionsInEnvironment {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListCookbookVersionsInEnvironmentImpl(ChefApi api) {
        super(api);
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(String environmentName) {
        return super.execute(Iterables.transform(this.api.listCookbooksInEnvironment(environmentName), (Function)new Function<CookbookDefinition, String>(){

            public String apply(CookbookDefinition cookbookDefinition) {
                return cookbookDefinition.getName();
            }
        }));
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(String environmentName, String numVersions) {
        return super.execute(Iterables.transform(this.api.listCookbooksInEnvironment(environmentName, numVersions), (Function)new Function<CookbookDefinition, String>(){

            public String apply(CookbookDefinition cookbookDefinition) {
                return cookbookDefinition.getName();
            }
        }));
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(ExecutorService executor, String environmentName) {
        return this.executeConcurrently(MoreExecutors.listeningDecorator((ExecutorService)executor), environmentName);
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(ExecutorService executor, String environmentName, String numVersions) {
        return this.executeConcurrently(MoreExecutors.listeningDecorator((ExecutorService)executor), environmentName, numVersions);
    }

    private Iterable<? extends CookbookVersion> executeConcurrently(ListeningExecutorService executor, String environmentName) {
        return super.execute(Iterables.transform(this.api.listCookbooksInEnvironment(environmentName), (Function)new Function<CookbookDefinition, String>(){

            public String apply(CookbookDefinition cookbookDefinition) {
                return cookbookDefinition.getName();
            }
        }));
    }

    private Iterable<? extends CookbookVersion> executeConcurrently(ListeningExecutorService executor, String environmentName, String numVersions) {
        return super.execute(Iterables.transform(this.api.listCookbooksInEnvironment(environmentName, numVersions), (Function)new Function<CookbookDefinition, String>(){

            public String apply(CookbookDefinition cookbookDefinition) {
                return cookbookDefinition.getName();
            }
        }));
    }
}

