/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet20;

import java.net.URL;
import java.sql.SQLException;
import org.fao.geonet.Logger;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.geonet20.Aligner;
import org.fao.geonet.kernel.harvest.harvester.geonet20.GeonetParams;
import org.fao.geonet.kernel.harvest.harvester.geonet20.GeonetResult;
import org.fao.geonet.kernel.harvest.harvester.geonet20.Search;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Content;
import org.jdom.Element;

public class Geonet20Harvester
extends AbstractHarvester<HarvestResult, GeonetParams> {
    private GeonetResult result;
    private String servletName;

    @Override
    protected GeonetParams createParams() {
        return new GeonetParams(this.dataMan);
    }

    @Override
    protected void storeNodeExtra(GeonetParams params, String path, String siteId, String optionsId) throws SQLException {
        this.setParams(params);
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"host", (Object)params.host);
        for (Search s : params.getSearches()) {
            String searchID = this.harvesterSettingsManager.add(path, (Object)"search", (Object)"");
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"freeText", (Object)s.freeText);
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"title", (Object)s.title);
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"abstract", (Object)s.abstrac);
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"keywords", (Object)s.keywords);
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"digital", (Object)s.digital);
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"hardcopy", (Object)s.hardcopy);
            this.harvesterSettingsManager.add("id:" + searchID, (Object)"siteId", (Object)s.siteId);
        }
    }

    @Override
    public void addHarvestInfo(Element info, String id, String uuid) {
        super.addHarvestInfo(info, id, uuid);
        String small = ((GeonetParams)this.params).host + "/srv/en/resources.get2?access=public&uuid=" + uuid + "&fname=";
        info.addContent((Content)new Element("smallThumbnail").setText(small));
    }

    @Override
    protected void doAddInfo(Element node) {
        if (this.result == null) {
            return;
        }
        Element info = node.getChild("info");
        for (HarvestResult ar : this.result.alResult) {
            Element site = new Element("search");
            site.setAttribute("siteId", ar.siteId);
            this.add(site, "total", ar.totalMetadata);
            this.add(site, "added", ar.addedMetadata);
            this.add(site, "updated", ar.updatedMetadata);
            this.add(site, "unchanged", ar.unchangedMetadata);
            this.add(site, "skipped", ar.schemaSkipped + ar.uuidSkipped);
            this.add(site, "removed", ar.locallyRemoved);
            this.add(site, "doesNotValidate", ar.doesNotValidate);
            info.addContent((Content)site);
        }
    }

    @Override
    public Element getResult() {
        return new Element("result");
    }

    @Override
    public void doHarvest(Logger log) throws Exception {
        CategoryMapper localCateg = new CategoryMapper(this.context);
        URL url = new URL(((GeonetParams)this.params).host);
        XmlRequest req = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(url.getHost(), url.getPort());
        this.servletName = url.getPath();
        Lib.net.setupProxy(this.context, req);
        String name = ((GeonetParams)this.getParams()).getName();
        if (((GeonetParams)this.params).isUseAccount()) {
            log.info("Login into : " + name);
            req.setAddress(this.servletName + "/srv/en/" + "xml.user.login");
            req.addParam("username", (Object)((GeonetParams)this.params).getUsername());
            req.addParam("password", (Object)((GeonetParams)this.params).getPassword());
            Element response = req.execute();
            if (!response.getName().equals("ok")) {
                throw new UserNotFoundEx(((GeonetParams)this.params).getUsername());
            }
        }
        if (this.cancelMonitor.get()) {
            return;
        }
        this.result = new GeonetResult();
        Aligner aligner = new Aligner(this.cancelMonitor, log, req, (GeonetParams)this.params, this.dataMan, this.metadataManager, this.context, localCateg);
        for (Search s : ((GeonetParams)this.params).getSearches()) {
            if (this.cancelMonitor.get()) {
                return;
            }
            log.info("Searching on : " + name + "/" + s.siteId);
            req.setAddress(this.servletName + "/srv/en/" + "xml.search");
            Element searchResult = req.execute(s.createRequest());
            if (log.isDebugEnabled()) {
                log.debug("Obtained:\n" + Xml.getString((Element)searchResult));
            }
            HarvestResult ar = aligner.align(searchResult, s.siteId);
            this.result.alResult.add(ar);
        }
        if (((GeonetParams)this.params).isUseAccount()) {
            log.info("Logout from : " + name);
            req.clearParams();
            req.setAddress("/" + ((GeonetParams)this.params).getServletPath() + "/srv/en/" + "xml.user.logout");
        }
        this.metadataManager.flush();
    }
}

