/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.utilint.VLSN;

public class ReplicationContext {
    public static final ReplicationContext MASTER = new ReplicationContext(true);
    public static final ReplicationContext NO_REPLICATE = new ReplicationContext(false);
    private final boolean inReplicationStream;
    private final VLSN clientVLSN;

    protected ReplicationContext(boolean inReplicationStream) {
        this.inReplicationStream = inReplicationStream;
        this.clientVLSN = null;
    }

    public ReplicationContext(VLSN clientVLSN) {
        this.inReplicationStream = true;
        this.clientVLSN = clientVLSN;
    }

    public VLSN getClientVLSN() {
        return this.clientVLSN;
    }

    public boolean inReplicationStream() {
        return this.inReplicationStream;
    }

    boolean mustGenerateVLSN() {
        return this.inReplicationStream && this.clientVLSN == null;
    }

    public DbOperationType getDbOperationType() {
        return DbOperationType.NONE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("inRepStream=").append(this.inReplicationStream);
        sb.append("clientVLSN=").append(this.clientVLSN);
        return sb.toString();
    }
}

