/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.UserSecurity;
import org.fao.geonet.domain.converter.BooleanToYNConverter;
import org.fao.geonet.entitylistener.UserEntityListenerManager;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="Users")
@Cacheable
@EntityListeners(value={UserEntityListenerManager.class})
@SequenceGenerator(name="user_id_seq", initialValue=100, allocationSize=1)
public class User
extends GeonetEntity
implements UserDetails {
    public static final String TABLE_NAME = "Users";
    public static final String ID_COLUMN_NAME = "id";
    public static final String LAST_LOGIN_DATE_COLUMN_NAME = "lastLoginDate";
    public static final String NODE_APPLICATION_CONTEXT_KEY = "jeevesNodeApplicationContext_";
    static final String ID_SEQ_NAME = "user_id_seq";
    private static final long serialVersionUID = 2589607276443866650L;
    private int _id;
    private String _username;
    private String _surname;
    private String _name;
    private Set<String> _email = new HashSet<String>();
    private Set<Address> _addresses = new LinkedHashSet<Address>();
    private String _organisation;
    private String _kind;
    private Profile _profile = Profile.RegisteredUser;
    private UserSecurity _security = new UserSecurity();
    private String _lastLoginDate;
    private Boolean _isEnabled;

    public static String getRandomPassword() {
        StringKeyGenerator generator = KeyGenerators.string();
        return generator.generateKey().substring(0, 8);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="user_id_seq")
    @Column(name="id")
    public int getId() {
        return this._id;
    }

    @Nonnull
    public User setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false, unique=true)
    @Nonnull
    public String getUsername() {
        return this._username;
    }

    @Nonnull
    public User setUsername(@Nonnull String username) {
        this._username = username;
        return this;
    }

    @Transient
    @JsonIgnore
    public String getPassword() {
        return new String(this.getSecurity().getPassword());
    }

    @Nullable
    public String getSurname() {
        return this._surname;
    }

    @Nonnull
    public User setSurname(@Nullable String surname) {
        this._surname = surname;
        return this;
    }

    @Nullable
    public String getName() {
        return this._name;
    }

    @Nonnull
    public User setName(@Nullable String name) {
        this._name = name;
        return this;
    }

    @Transient
    public String getEmail() {
        if (this._email != null) {
            for (String email : this._email) {
                if (!email.contains("@")) continue;
                return email;
            }
        }
        return null;
    }

    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @CollectionTable(name="email")
    @Column(name="email")
    public Set<String> getEmailAddresses() {
        return this._email;
    }

    public User setEmailAddresses(Set<String> email) {
        this._email = email;
        return this;
    }

    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinTable(name="UserAddress", joinColumns={@JoinColumn(name="userid")}, inverseJoinColumns={@JoinColumn(name="addressid", referencedColumnName="ID", unique=true)})
    public Set<Address> getAddresses() {
        return this._addresses;
    }

    protected User setAddresses(Set<Address> addresses) {
        this._addresses = addresses;
        return this;
    }

    @Transient
    @Nonnull
    public Address getPrimaryAddress() {
        Set<Address> addresses = this.getAddresses();
        Address addressCopy = new Address();
        if (!addresses.isEmpty()) {
            Address otherAddress = addresses.iterator().next();
            addressCopy.mergeAddress(otherAddress, true);
            addressCopy.setId(otherAddress.getId());
        }
        return addressCopy;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public User setOrganisation(String organization) {
        this._organisation = organization;
        return this;
    }

    @Column(length=16)
    public String getKind() {
        return this._kind;
    }

    @Nonnull
    public User setKind(String kind) {
        this._kind = kind;
        return this;
    }

    @Column(nullable=false)
    @Nonnull
    public Profile getProfile() {
        return this._profile;
    }

    @Nonnull
    public User setProfile(@Nonnull Profile profile) {
        this._profile = profile;
        return this;
    }

    @Nonnull
    public UserSecurity getSecurity() {
        return this._security;
    }

    @Nonnull
    protected User setSecurity(@Nonnull UserSecurity security) {
        this._security = security;
        return this;
    }

    @Nullable
    @Column(name="lastLoginDate")
    public String getLastLoginDate() {
        return this._lastLoginDate;
    }

    @Nonnull
    public User setLastLoginDate(@Nullable String lastLoginDate) {
        this._lastLoginDate = lastLoginDate;
        return this;
    }

    @Transient
    public Collection<GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> auths = new ArrayList<GrantedAuthority>();
        String nodeId = this.getSecurity().getNodeId();
        if (nodeId != null) {
            auths.add((GrantedAuthority)new SimpleGrantedAuthority(NODE_APPLICATION_CONTEXT_KEY));
        }
        if (this._profile != null) {
            for (String p : this.getProfile().getAllNames()) {
                auths.add((GrantedAuthority)new SimpleGrantedAuthority(p));
            }
        }
        return auths;
    }

    @Transient
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Column(name="isenabled", nullable=false, length=1, columnDefinition="CHAR(1) DEFAULT 'y'")
    @Convert(converter=BooleanToYNConverter.class)
    public boolean isEnabled() {
        if (this._isEnabled == null) {
            this._isEnabled = true;
        }
        return this._isEnabled;
    }

    public User setEnabled(Boolean enabled) {
        this._isEnabled = enabled;
        return this;
    }

    public void mergeUser(User otherUser, boolean mergeNullData) {
        if (mergeNullData || StringUtils.isNotBlank((String)otherUser.getUsername())) {
            this.setUsername(otherUser.getUsername());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherUser.getSurname())) {
            this.setSurname(otherUser.getSurname());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherUser.getName())) {
            this.setName(otherUser.getName());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherUser.getOrganisation())) {
            this.setOrganisation(otherUser.getOrganisation());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherUser.getKind())) {
            this.setKind(otherUser.getKind());
        }
        if (mergeNullData || StringUtils.isNotBlank((String)otherUser.getProfile().name())) {
            this.setProfile(otherUser.getProfile());
        }
        if (mergeNullData || !otherUser.getEmailAddresses().isEmpty()) {
            this._email.clear();
            this._email.addAll(otherUser.getEmailAddresses());
        }
        ArrayList<Address> otherAddresses = new ArrayList<Address>(otherUser.getAddresses());
        if (mergeNullData || !otherAddresses.isEmpty()) {
            Iterator<Address> iterator = this._addresses.iterator();
            while (iterator.hasNext()) {
                Address address = iterator.next();
                boolean found = false;
                Iterator<Address> iterator2 = otherAddresses.iterator();
                while (iterator2.hasNext()) {
                    Address otherAddress = iterator2.next();
                    if (otherAddress.getId() != address.getId()) continue;
                    address.mergeAddress(otherAddress, mergeNullData);
                    found = true;
                    iterator2.remove();
                    break;
                }
                if (found) continue;
                iterator.remove();
            }
            this._addresses.addAll(otherAddresses);
        }
        this.getSecurity().mergeSecurity(otherUser.getSecurity(), mergeNullData);
    }

    public String toString() {
        return this.getUsername() + "(" + this.getId() + ") - " + (Object)((Object)this.getProfile());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        if (this._id != user._id) {
            return false;
        }
        if (!this._addresses.equals(user._addresses)) {
            return false;
        }
        if (!this._email.equals(user._email)) {
            return false;
        }
        if (this._kind != null ? !this._kind.equals(user._kind) : user._kind != null) {
            return false;
        }
        if (this._name != null ? !this._name.equals(user._name) : user._name != null) {
            return false;
        }
        if (this._organisation != null ? !this._organisation.equals(user._organisation) : user._organisation != null) {
            return false;
        }
        if (this._profile != user._profile) {
            return false;
        }
        if (!this._security.equals(user._security)) {
            return false;
        }
        if (this._surname != null ? !this._surname.equals(user._surname) : user._surname != null) {
            return false;
        }
        if (this._username != null ? !this._username.equals(user._username) : user._username != null) {
            return false;
        }
        return !(this._lastLoginDate != null ? !this._lastLoginDate.equals(user._lastLoginDate) : user._lastLoginDate != null);
    }

    public int hashCode() {
        int result = this._id;
        result = 31 * result + (this._username != null ? this._username.hashCode() : 0);
        result = 31 * result + (this._surname != null ? this._surname.hashCode() : 0);
        result = 31 * result + (this._name != null ? this._name.hashCode() : 0);
        result = 31 * result + this._email.hashCode();
        result = 31 * result + this._addresses.hashCode();
        result = 31 * result + (this._organisation != null ? this._organisation.hashCode() : 0);
        result = 31 * result + (this._kind != null ? this._kind.hashCode() : 0);
        result = 31 * result + (this._profile != null ? this._profile.hashCode() : 0);
        result = 31 * result + this._security.hashCode();
        result = 31 * result + (this._lastLoginDate != null ? this._lastLoginDate.hashCode() : 0);
        return result;
    }
}

