/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.SettingDataType;

public class SettingToObjectSerializer
extends JsonSerializer<Setting> {
    public void serialize(Setting s, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", s.getName());
        jsonGenerator.writeStringField("dataType", s.getDataType() == null ? null : s.getDataType().name());
        jsonGenerator.writeNumberField("position", s.getPosition());
        jsonGenerator.writeBooleanField("internal", s.isInternal());
        jsonGenerator.writeBooleanField("editable", s.isEditable());
        jsonGenerator.writeFieldName("value");
        SettingToObjectSerializer.writeSettingValue(s, jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    public static void writeSettingValue(Setting s, JsonGenerator jsonGenerator) throws IOException {
        try {
            if (StringUtils.isNotEmpty((String)s.getValue())) {
                if (s.getDataType() == SettingDataType.BOOLEAN) {
                    jsonGenerator.writeBoolean(Boolean.parseBoolean(s.getValue()));
                } else if (s.getDataType() == SettingDataType.INT) {
                    jsonGenerator.writeNumber(Integer.parseInt(s.getValue()));
                } else if (s.getDataType() == SettingDataType.JSON) {
                    ObjectMapper mapper = new ObjectMapper();
                    jsonGenerator.writeTree((TreeNode)mapper.readTree(s.getValue()));
                } else {
                    jsonGenerator.writeString(s.getValue());
                }
            } else {
                jsonGenerator.writeNull();
            }
        }
        catch (Exception e) {
            jsonGenerator.writeNull();
            jsonGenerator.writeStringField("erroneousValue", s.getValue());
            jsonGenerator.writeStringField("error", e.getMessage());
        }
    }
}

