/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CoverageInstrumentationPass;
import com.google.javascript.jscomp.CoverageUtil;
import com.google.javascript.jscomp.FileInstrumentationData;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Map;

class CoverageInstrumentationCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final Map<String, FileInstrumentationData> instrumentationData;
    private CoverageInstrumentationPass.CoverageReach reach;
    static final String ARRAY_NAME_PREFIX = "JSCompiler_lcov_data_";

    public CoverageInstrumentationCallback(Map<String, FileInstrumentationData> instrumentationData, CoverageInstrumentationPass.CoverageReach reach) {
        this.instrumentationData = instrumentationData;
        this.reach = reach;
    }

    private static String getFileName(NodeTraversal traversal) {
        return traversal.getSourceName();
    }

    private String createArrayName(NodeTraversal traversal) {
        return ARRAY_NAME_PREFIX + CoverageUtil.createIdentifierFromText(CoverageInstrumentationCallback.getFileName(traversal));
    }

    private Node newInstrumentationNode(NodeTraversal traversal, int lineNumber) {
        String fileName = CoverageInstrumentationCallback.getFileName(traversal);
        String arrayName = this.createArrayName(traversal);
        Node nameNode = IR.name(arrayName);
        Node numNode = IR.number(lineNumber - 1);
        Node getElemNode = IR.getelem(nameNode, numNode);
        Node trueNode = IR.trueNode();
        Node assignNode = IR.assign(getElemNode, trueNode);
        Node exprNode = IR.exprResult(assignNode);
        if (!this.instrumentationData.containsKey(fileName)) {
            this.instrumentationData.put(fileName, new FileInstrumentationData(fileName, arrayName));
        }
        this.instrumentationData.get(fileName).setLineAsInstrumented(lineNumber);
        return exprNode;
    }

    private Node newArrayDeclarationNode(NodeTraversal traversal) {
        Node arraylitNode = IR.arraylit(new Node[0]);
        Node nameNode = IR.name(this.createArrayName(traversal));
        nameNode.addChildToFront(arraylitNode);
        Node varNode = IR.var(nameNode);
        return varNode;
    }

    private Node newHeaderNode(NodeTraversal traversal) {
        String fileName = CoverageInstrumentationCallback.getFileName(traversal);
        String arrayName = this.createArrayName(traversal);
        FileInstrumentationData data = this.instrumentationData.get(fileName);
        Preconditions.checkNotNull((Object)data);
        return IR.block(this.newArrayDeclarationNode(traversal), IR.exprResult(IR.call(IR.getprop(IR.name("JSCompiler_lcov_executedLines"), IR.string("push")), IR.name(arrayName))), IR.exprResult(IR.call(IR.getprop(IR.name("JSCompiler_lcov_instrumentedLines"), IR.string("push")), IR.string(data.getInstrumentedLinesAsHexString()))), IR.exprResult(IR.call(IR.getprop(IR.name("JSCompiler_lcov_fileNames"), IR.string("push")), IR.string(fileName))));
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        if (node.isScript()) {
            String fileName = CoverageInstrumentationCallback.getFileName(traversal);
            if (this.instrumentationData.get(fileName) != null) {
                node.addChildToFront(this.newHeaderNode(traversal));
            }
            return;
        }
        if (this.reach == CoverageInstrumentationPass.CoverageReach.CONDITIONAL && parent != null && parent.isScript()) {
            return;
        }
        if (node.isFunction() || node.isWith() || node.isCase() || node.isDefaultCase() || node.isCatch()) {
            Node codeBlock = node.getLastChild();
            codeBlock.addChildToFront(this.newInstrumentationNode(traversal, node.getLineno()));
            return;
        }
        if (node.isTry()) {
            Node firstChild = node.getFirstChild();
            firstChild.addChildToFront(this.newInstrumentationNode(traversal, node.getLineno()));
            return;
        }
        if (parent != null && NodeUtil.isStatementBlock(parent)) {
            parent.addChildBefore(this.newInstrumentationNode(traversal, node.getLineno()), node);
            return;
        }
    }
}

