/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.InputStream;
import java.util.Vector;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.CodeTable;

public class AnselToUnicode
implements CharConverter {
    protected CodeTable ct;
    protected boolean loadedMultibyte;
    static /* synthetic */ Class class$0;

    public AnselToUnicode() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.marc4j.converter.impl.AnselToUnicode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz.getResourceAsStream("resources/codetablesnocjk.xml"));
    }

    public AnselToUnicode(String pathname) {
        this.loadedMultibyte = false;
        this.ct = new CodeTable(pathname);
        this.loadedMultibyte = true;
    }

    public AnselToUnicode(InputStream in) {
        this.loadedMultibyte = false;
        this.ct = new CodeTable(in);
        this.loadedMultibyte = true;
    }

    private void loadMultibyte() {
        this.ct = new CodeTable(this.getClass().getResourceAsStream("resources/codetables.xml"));
    }

    private void checkMode(char[] data, CodeTracker cdt) {
        while (cdt.offset < data.length && AnselToUnicode.isEscape(data[cdt.offset])) {
            block0 : switch (data[cdt.offset + 1]) {
                case '(': 
                case ',': {
                    cdt.g0 = data[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.multibyte = false;
                    break;
                }
                case ')': 
                case '-': {
                    cdt.g1 = data[cdt.offset + 2];
                    cdt.offset += 3;
                    cdt.multibyte = false;
                    break;
                }
                case '$': {
                    cdt.multibyte = true;
                    if (!this.loadedMultibyte) {
                        this.loadMultibyte();
                        this.loadedMultibyte = true;
                    }
                    switch (data[cdt.offset + 1]) {
                        case ')': 
                        case '-': {
                            cdt.g1 = data[cdt.offset + 3];
                            cdt.offset += 4;
                            break block0;
                        }
                        case ',': {
                            cdt.g0 = data[cdt.offset + 3];
                            cdt.offset += 4;
                            break block0;
                        }
                    }
                    cdt.g0 = data[cdt.offset + 2];
                    cdt.offset += 3;
                    break;
                }
                case 'b': 
                case 'g': 
                case 'p': {
                    cdt.g0 = data[cdt.offset + 1];
                    cdt.offset += 2;
                    cdt.multibyte = false;
                    break;
                }
                case 's': {
                    cdt.g0 = 66;
                    cdt.offset += 2;
                    cdt.multibyte = false;
                }
            }
        }
    }

    public String convert(String dataElement) {
        char[] data = null;
        data = dataElement.toCharArray();
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        CodeTracker cdt = new CodeTracker();
        cdt.g0 = 66;
        cdt.g1 = 69;
        cdt.multibyte = false;
        cdt.offset = 0;
        this.checkMode(data, cdt);
        Queue diacritics = new Queue();
        while (cdt.offset < data.length) {
            if (this.ct.isCombining(data[cdt.offset], cdt.g0, cdt.g1) && AnselToUnicode.hasNext(cdt.offset, len)) {
                while (this.ct.isCombining(data[cdt.offset], cdt.g0, cdt.g1) && AnselToUnicode.hasNext(cdt.offset, len)) {
                    diacritics.put(new Character(this.getChar(data[cdt.offset], cdt.g0, cdt.g1)));
                    ++cdt.offset;
                    this.checkMode(data, cdt);
                }
                char c2 = this.getChar(data[cdt.offset], cdt.g0, cdt.g1);
                ++cdt.offset;
                this.checkMode(data, cdt);
                sb.append(c2);
                while (!diacritics.isEmpty()) {
                    char c1 = ((Character)diacritics.get()).charValue();
                    sb.append(c1);
                }
            } else if (cdt.multibyte) {
                sb.append(this.ct.getChar(this.makeMultibyte(new String(data).substring(cdt.offset, cdt.offset + 4).toCharArray()), cdt.g0));
                cdt.offset += 3;
            } else {
                sb.append(this.getChar(data[cdt.offset], cdt.g0, cdt.g1));
                ++cdt.offset;
            }
            if (!AnselToUnicode.hasNext(cdt.offset, len)) continue;
            this.checkMode(data, cdt);
        }
        return sb.toString();
    }

    private int makeMultibyte(char[] data) {
        int[] chars = new int[]{data[0] << 16, data[1] << 8, data[2]};
        return chars[0] | chars[1] | chars[2];
    }

    private char getChar(int ch, int g0, int g1) {
        if (ch <= 126) {
            return this.ct.getChar(ch, g0);
        }
        return this.ct.getChar(ch, g1);
    }

    private char getMBChar(int ch) {
        return this.ct.getChar(ch, 49);
    }

    private static boolean hasNext(int pos, int len) {
        return pos < len - 1;
    }

    private static boolean isEscape(int i) {
        return i == 27;
    }

    class Queue
    extends Vector {
        Queue() {
        }

        public Object put(Object item) {
            this.addElement(item);
            return item;
        }

        public Object get() {
            int len = this.size();
            Object obj = this.peek();
            this.removeElementAt(0);
            return obj;
        }

        public Object peek() {
            int len = this.size();
            return this.elementAt(0);
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    class CodeTracker {
        int offset;
        int g0;
        int g1;
        boolean multibyte;

        CodeTracker() {
        }

        public String toString() {
            return "Offset: " + this.offset + " G0: " + Integer.toHexString(this.g0) + " G1: " + Integer.toHexString(this.g1) + " Multibyte: " + this.multibyte;
        }
    }
}

