/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.dynect.v3.domain.GeoRegionGroup;
import org.jclouds.dynect.v3.domain.GeoService;
import org.jclouds.dynect.v3.domain.Node;
import org.jclouds.dynect.v3.domain.RecordSet;
import org.jclouds.dynect.v3.domain.SessionCredentials;

public class DynECTParserModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    public final Map<Type, Object> provideCustomAdapterBindings() {
        return new ImmutableMap.Builder().put(SessionCredentials.class, (Object)new SessionCredentialsTypeAdapter()).put(GeoRegionGroup.class, (Object)new GeoRegionGroupTypeAdapter()).put(GeoService.class, (Object)new GeoServiceTypeAdapter()).build();
    }

    private static class CreepyGeoService {
        String name;
        String active;
        int ttl;
        List<Node> nodes;
        List<GeoRegionGroup> groups;

        private CreepyGeoService() {
        }
    }

    private static class GeoServiceTypeAdapter
    implements JsonDeserializer<GeoService> {
        private GeoServiceTypeAdapter() {
        }

        public GeoService deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CreepyGeoService creepyGeoService = (CreepyGeoService)context.deserialize(json, CreepyGeoService.class);
            GeoService.Builder builder = GeoService.builder();
            builder.name(creepyGeoService.name);
            builder.active("Y".equals(creepyGeoService.active));
            builder.ttl(creepyGeoService.ttl);
            builder.nodes(creepyGeoService.nodes);
            builder.groups(creepyGeoService.groups);
            return builder.build();
        }
    }

    private static class CreepyGeoRegionGroup {
        String name;
        Map<String, List<Integer>> weight;
        List<String> countries;
        String service_name;
        Map<String, List<Map<String, Object>>> rdata;
        Map<String, List<String>> label;
        Map<String, Integer> ttl;

        private CreepyGeoRegionGroup() {
        }
    }

    private static class GeoRegionGroupTypeAdapter
    implements JsonDeserializer<GeoRegionGroup> {
        private GeoRegionGroupTypeAdapter() {
        }

        public GeoRegionGroup deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            CreepyGeoRegionGroup creepyGeoRegionGroup = (CreepyGeoRegionGroup)context.deserialize(json, CreepyGeoRegionGroup.class);
            GeoRegionGroup.Builder builder = GeoRegionGroup.builder();
            builder.name(creepyGeoRegionGroup.name);
            builder.serviceName(creepyGeoRegionGroup.service_name);
            builder.countries(creepyGeoRegionGroup.countries);
            ImmutableList.Builder rsets = ImmutableList.builder();
            for (Map.Entry<String, List<Map<String, Object>>> entry : creepyGeoRegionGroup.rdata.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                String type = entry.getKey().substring(0, entry.getKey().indexOf(95)).toUpperCase();
                int ttl = creepyGeoRegionGroup.ttl.get(type.toLowerCase() + "_ttl");
                RecordSet.Builder rset = RecordSet.builder();
                rset.type(type);
                rset.ttl(ttl);
                ImmutableList weights = creepyGeoRegionGroup.weight.get(type.toLowerCase() + "_weight");
                if (weights == null) {
                    weights = ImmutableList.of();
                }
                List<String> labels = creepyGeoRegionGroup.label.get(type.toLowerCase() + "_label");
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    RecordSet.Value.Builder elementBuilder = RecordSet.Value.builder().rdata(entry.getValue().get(i));
                    if (i < labels.size()) {
                        elementBuilder.label(labels.get(i));
                    }
                    if (i < weights.size()) {
                        elementBuilder.weight((Integer)weights.get(i));
                    }
                    rset.add(elementBuilder.build());
                }
                rsets.add((Object)rset.build());
            }
            builder.recordSets((Iterable<RecordSet>)rsets.build());
            return builder.build();
        }
    }

    private static class SessionCredentialsTypeAdapter
    implements JsonSerializer<SessionCredentials> {
        private SessionCredentialsTypeAdapter() {
        }

        public JsonElement serialize(SessionCredentials src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject metadataObject = new JsonObject();
            metadataObject.addProperty("customer_name", src.getCustomerName());
            metadataObject.addProperty("user_name", src.getUserName());
            metadataObject.addProperty("password", src.getPassword());
            return metadataObject;
        }
    }
}

