/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.model.Graph;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class GraphQueryRemoveServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"repository");
        String query = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"query");
        String queryLanguageStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"queryLanguage");
        String resultFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        this._handleRequest(request, response, repository, query, queryLanguageStr, resultFormatStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String repository = HttpServerUtil.getParameter((Map)fileItemMap, (String)"repository");
        String query = HttpServerUtil.getParameter((Map)fileItemMap, (String)"query");
        String queryLanguageStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"queryLanguage");
        String resultFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        this._handleRequest(request, response, repository, query, queryLanguageStr, resultFormatStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String query, String queryLanguageStr, String resultFormatStr) throws IOException {
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log((String)">>> remove from graph query");
        ThreadLog.trace((String)("repository = " + repository));
        ThreadLog.trace((String)("query = " + query));
        ThreadLog.trace((String)("queryLanguage = " + queryLanguageStr));
        ThreadLog.trace((String)("resultFormat = " + resultFormatStr));
        if (query == null) {
            this._sendBadRequest("Query is missing", response);
            return;
        }
        QueryLanguage queryLanguage = QueryLanguage.SERQL;
        if (queryLanguageStr != null && (queryLanguage = QueryLanguage.forValue(queryLanguageStr)) == null) {
            this._sendBadRequest("Unsupported query language: " + queryLanguageStr, response);
            return;
        }
        if (repository == null) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setCacheableResult(false);
        AdminListener report = null;
        AdminResultFormat resultFormat = AdminResultFormat.forValue(resultFormatStr);
        if (resultFormat == AdminResultFormat.XML) {
            httpOut.setContentType("text/xml");
            report = new XmlAdminMsgWriter(httpOut);
        } else if (resultFormat == AdminResultFormat.HTML) {
            httpOut.setContentType("text/html");
            report = new HtmlAdminMsgWriter(httpOut);
        } else {
            this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
            return;
        }
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep = service.getRepository(repository);
            report.transactionStart();
            Graph toBeRemoved = rep.performGraphQuery(queryLanguage, query);
            report.status("removing graph...", -1, -1);
            long startTime = System.currentTimeMillis();
            rep.removeGraph(toBeRemoved);
            long endTime = System.currentTimeMillis();
            report.status("graph removed in " + (endTime - startTime) + " ms.", -1, -1);
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied: " + e.getMessage(), response);
        }
        catch (MalformedQueryException e) {
            this._sendBadRequest(HTTPErrorType.MALFORMED_QUERY, e.getMessage(), response);
        }
        catch (QueryEvaluationException e) {
            ThreadLog.warning((String)("Query evaluation error: " + e.getMessage()));
            this._sendBadRequest(HTTPErrorType.QUERY_EVALUATION_ERROR, e.getMessage(), response);
        }
        catch (IOException ie) {
            ThreadLog.warning((String)("I/O error, client connection closed?\n" + ie.getMessage()));
        }
        catch (Exception e) {
            ThreadLog.error((String)("Unknown error on query: " + query), (Object)e);
            this._sendBadRequest(HTTPErrorType.QUERY_EVALUATION_ERROR, e.getMessage(), response);
        }
        finally {
            report.transactionEnd();
        }
    }
}

