/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;

public class StandardSocketFactory
extends SocketFactory {
    @Override
    public Socket createSocket() throws IOException {
        return SocketChannel.open().socket();
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(addr, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress localHostAddr, int localPort) throws IOException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHostAddr, localPort));
        socket.connect(new InetSocketAddress(addr, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHostAddr, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHostAddr, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof StandardSocketFactory;
    }

    public int hashCode() {
        return 47;
    }
}

