/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.CSS)
public class Less4jProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(Less4jProcessor.class);
    public static final String ALIAS = "less4j";
    @Inject
    private UriLocatorFactory locatorFactory;
    private final LessCompiler compiler = new DefaultLessCompiler();

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            RelativeAwareLessSource lessSource = new RelativeAwareLessSource(resource, IOUtils.toString((Reader)reader), this.locatorFactory);
            LessCompiler.CompilationResult result = this.compiler.compile((LessSource)lessSource);
            this.logWarnings(result);
            writer.write(result.getCss());
        }
        catch (Less4jException e) {
            LOG.error("Failed to compile less resource: {}.", (Object)resource);
            for (LessCompiler.Problem problem : e.getErrors()) {
                LOG.error(this.problemAsString(problem));
            }
            throw WroRuntimeException.wrap((Exception)((Object)e));
        }
    }

    private void logWarnings(LessCompiler.CompilationResult result) {
        if (!result.getWarnings().isEmpty()) {
            LOG.warn("Less warnings are:");
            for (LessCompiler.Problem problem : result.getWarnings()) {
                LOG.warn(this.problemAsString(problem));
            }
        }
    }

    private String problemAsString(LessCompiler.Problem problem) {
        return String.format("%s:%s %s.", problem.getLine(), problem.getCharacter(), problem.getMessage());
    }

    private static class RelativeAwareLessSource
    extends LessSource.StringSource {
        private final Resource resource;
        private final UriLocatorFactory locatorFactory;

        public RelativeAwareLessSource(Resource resource, String content, UriLocatorFactory locatorFactory) {
            super(content);
            this.resource = resource;
            Validate.notNull((Object)locatorFactory);
            this.locatorFactory = locatorFactory;
        }

        public LessSource relativeSource(String relativePath) throws LessSource.StringSourceException {
            return this.resource != null ? this.computeRelative(this.resource, relativePath) : super.relativeSource(relativePath);
        }

        private LessSource computeRelative(Resource resource, String relativePath) throws LessSource.StringSourceException {
            try {
                String relativeResourceUri = this.computeRelativeResourceUri(resource.getUri(), relativePath);
                Resource relativeResource = Resource.create((String)relativeResourceUri, (ResourceType)ResourceType.CSS);
                String relativeResourceContent = IOUtils.toString((InputStream)this.locatorFactory.locate(relativeResourceUri), (String)"UTF-8");
                return new RelativeAwareLessSource(relativeResource, relativeResourceContent, this.locatorFactory);
            }
            catch (IOException e) {
                LOG.error("Failed to compute relative resource: " + resource, (Throwable)e);
                throw new LessSource.StringSourceException();
            }
        }

        public String computeRelativeResourceUri(String originalResourceUri, String relativePath) {
            String fullPath = WroUtil.getFullPath((String)originalResourceUri) + relativePath;
            return WroUtil.normalize((String)fullPath);
        }
    }
}

