/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.mail;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/tools/mail"})
@Tag(name="tools", description="Utility operations")
@Controller(value="mail")
public class MailApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    SettingManager settingManager;

    @Operation(summary="Test mail configuration", description="Send an email to the catalog feedback email.")
    @RequestMapping(value={"/test"}, produces={"text/plain"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('Administrator')")
    public ResponseEntity<String> testMailConfiguration(ServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale);
        String to = this.settingManager.getValue("system/feedback/email");
        String subject = String.format(messages.getString("mail_config_test_subject"), this.settingManager.getSiteName(), to);
        String message = String.format(messages.getString("mail_config_test_message"), this.settingManager.getNodeURL(), this.settingManager.getNodeURL(), this.settingManager.getNodeURL());
        try {
            MailUtil.testSendMail((String)to, (String)subject, null, (String)message, (SettingManager)this.settingManager, (String)to, (String)"");
            return new ResponseEntity((Object)String.format(messages.getString("mail_config_test_success"), to), HttpStatus.CREATED);
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.api", (Object)"Error sending test email", (Throwable)ex);
            String error = ex.getMessage();
            if (ex.getCause() != null) {
                error = error + ". " + ex.getCause().getMessage();
            }
            return new ResponseEntity((Object)String.format(error, new Object[0]), HttpStatus.PRECONDITION_FAILED);
        }
    }
}

