/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.elasticsearch.action.search.SearchResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.springframework.context.ConfigurableApplicationContext;

public class IndexHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() {
                try {
                    ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                    EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
                    SearchResponse result = searchMan.query("*", null, 0, 0);
                    if (result.status().getStatus() == 200) {
                        return HealthCheck.Result.healthy((String)String.format("%s records indexed in remote index currently.", result.getHits().getTotalHits().value));
                    }
                    return HealthCheck.Result.unhealthy((String)"Index storing records is not available currently. This component is required. Check your installation.");
                }
                catch (Throwable e) {
                    return HealthCheck.Result.unhealthy((Throwable)e);
                }
            }
        };
    }
}

