/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;

public abstract class MetadataFieldMapper
extends FieldMapper {
    public static FieldMapper.Parameter<Explicit<Boolean>> updateableBoolParam(String name, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
        Explicit<Boolean> defaultExplicit = new Explicit<Boolean>(defaultValue, false);
        return new FieldMapper.Parameter<Explicit<Boolean>>(name, true, () -> defaultExplicit, (n, c, o) -> new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(o), true), initializer).setSerializer((b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
    }

    protected MetadataFieldMapper(MappedFieldType mappedFieldType) {
        super(mappedFieldType.name(), mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    protected MetadataFieldMapper(MappedFieldType mappedFieldType, NamedAnalyzer indexAnalyzer) {
        super(mappedFieldType.name(), mappedFieldType, indexAnalyzer, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return null;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder mergeBuilder = (Builder)this.getMergeBuilder();
        if (mergeBuilder == null || !mergeBuilder.isConfigured()) {
            return builder;
        }
        builder.startObject(this.simpleName());
        this.getMergeBuilder().toXContent(builder, params);
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        throw new MapperParsingException("Field [" + this.name() + "] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
    }

    public void preParse(DocumentParserContext context) throws IOException {
    }

    public void postParse(DocumentParserContext context) throws IOException {
    }

    public static abstract class Builder
    extends FieldMapper.Builder {
        protected Builder(String name) {
            super(name);
        }

        boolean isConfigured() {
            for (FieldMapper.Parameter<?> param : this.getParameters()) {
                if (!param.isConfigured()) continue;
                return true;
            }
            return false;
        }

        @Override
        public final MetadataFieldMapper build(ContentPath path) {
            return this.build();
        }

        public abstract MetadataFieldMapper build();
    }

    public static class ConfigurableTypeParser
    implements TypeParser {
        final Function<MappingParserContext, MetadataFieldMapper> defaultMapperParser;
        final Function<MappingParserContext, Builder> builderFunction;

        public ConfigurableTypeParser(Function<MappingParserContext, MetadataFieldMapper> defaultMapperParser, Function<MappingParserContext, Builder> builderFunction) {
            this.defaultMapperParser = defaultMapperParser;
            this.builderFunction = builderFunction;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(parserContext);
            builder.parse(name, parserContext, node);
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappingParserContext parserContext) {
            return this.defaultMapperParser.apply(parserContext);
        }
    }

    public static class FixedTypeParser
    implements TypeParser {
        final Function<MappingParserContext, MetadataFieldMapper> mapperParser;

        public FixedTypeParser(Function<MappingParserContext, MetadataFieldMapper> mapperParser) {
            this.mapperParser = mapperParser;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException(name + " is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappingParserContext parserContext) {
            return this.mapperParser.apply(parserContext);
        }
    }

    public static interface TypeParser
    extends Mapper.TypeParser {
        @Override
        public Builder parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;

        public MetadataFieldMapper getDefault(MappingParserContext var1);
    }
}

