/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.z3950.QueryModel;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.codec.util.OIDRegisterEntry;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.z3950.QueryModel.Z3950QueryModel;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.AttributeElement_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.AttributesPlusTerm_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Operand_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Query_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.RPNQuery_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.RPNStructure_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.complex_inline4_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.rpnRpnOp_inline2_type;
import org.springframework.context.ApplicationContext;

public class Type1QueryModel
extends Z3950QueryModel {
    private RPNQuery_type query;
    private static Log log = LogFactory.getLog(Type1QueryModel.class);

    public Type1QueryModel(RPNQuery_type query) {
        log.info((Object)("Type1QueryModel::Type1QueryModel(" + query + ")"));
        this.query = query;
    }

    public Query_type toASNType() {
        log.info((Object)"toASNType()");
        Query_type qt = new Query_type();
        qt.which = 1;
        qt.o = this.query;
        return qt;
    }

    public InternalModelRootNode toInternalQueryModel(ApplicationContext ctx) throws InvalidQueryException {
        OIDRegister reg = (OIDRegister)ctx.getBean("OIDRegister");
        Properties attr_type_config = (Properties)ctx.getBean("RPNToInternalRules");
        return Type1QueryModel.traverse(this.query, reg, attr_type_config);
    }

    private static InternalModelRootNode traverse(RPNQuery_type q, OIDRegister reg, Properties attr_type_config) {
        Object result = null;
        if (q.attributeSet != null) {
            String attr_set = null;
            OIDRegisterEntry re = reg.lookupByOID(q.attributeSet);
            if (null != re) {
                attr_set = re.getName();
            }
            return new InternalModelRootNode((QueryNode)new InternalModelNamespaceNode(attr_set, Type1QueryModel.traverse(q.rpn, reg, attr_type_config, attr_set)));
        }
        return new InternalModelRootNode(Type1QueryModel.traverse(q.rpn, reg, attr_type_config, null));
    }

    private static QueryNode traverse(RPNStructure_type rpn, OIDRegister reg, Properties attr_type_config, String attrset) {
        block0 : switch (rpn.which) {
            case 0: {
                Operand_type ot = (Operand_type)rpn.o;
                switch (ot.which) {
                    case 0: {
                        AttributesPlusTerm_type apt = (AttributesPlusTerm_type)ot.o;
                        return Type1QueryModel.convertAPT(apt, reg, attr_type_config, attrset);
                    }
                    case 1: {
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                ComplexNode c = new ComplexNode(Type1QueryModel.traverse(((rpnRpnOp_inline2_type)rpn.o).rpn1, reg, attr_type_config, attrset), Type1QueryModel.traverse(((rpnRpnOp_inline2_type)rpn.o).rpn2, reg, attr_type_config, attrset), ((rpnRpnOp_inline2_type)rpn.o).op.which + 1);
                return c;
            }
        }
        return null;
    }

    public static final QueryNode convertAPT(AttributesPlusTerm_type apt, OIDRegister reg, Properties attr_type_config, String attrset) {
        AttrPlusTermNode aptn = new AttrPlusTermNode();
        if (apt.term.o instanceof byte[]) {
            aptn.setTerm((Object)new String((byte[])apt.term.o));
        } else {
            aptn.setTerm((Object)apt.term.o.toString());
        }
        for (int i = 0; i < apt.attributes.size(); ++i) {
            OIDRegisterEntry re;
            AttributeElement_type aet = (AttributeElement_type)apt.attributes.get(i);
            if (null != aet.attributeSet && null != (re = reg.lookupByOID(aet.attributeSet))) {
                attrset = re.getName();
            }
            Object attrval = null;
            switch (aet.attributeValue.which) {
                case 0: {
                    attrval = aet.attributeValue.o;
                    break;
                }
                case 1: {
                    complex_inline4_type complex = (complex_inline4_type)aet.attributeValue.o;
                    attrval = complex.list.get(0);
                }
            }
            String attr_type_string = attrset + "." + aet.attributeType;
            String internal_attr_type = (String)attr_type_config.get(attr_type_string);
            if (internal_attr_type != null) {
                AttrValue av = new AttrValue(attrset, aet.attributeType + "." + attrval);
                aptn.setAttr(internal_attr_type, (Object)av);
                continue;
            }
            log.warn((Object)("No mapping for " + attr_type_string + " amongst " + attr_type_config));
        }
        return aptn;
    }
}

