/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.jclouds.io.payloads.FilePayload;

public class Resource {
    private final String name;
    private final URI url;
    private final byte[] checksum;
    private final String path;
    private final String specificity;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"name", "url", "checksum", "path", "specificity"})
    protected Resource(String name, URI url, byte[] checksum, String path, String specificity) {
        this.name = name;
        this.url = url;
        this.checksum = checksum;
        this.path = path;
        this.specificity = specificity;
    }

    public String getName() {
        return this.name;
    }

    public URI getUrl() {
        return this.url;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public String getPath() {
        return this.path;
    }

    public String getSpecificity() {
        return this.specificity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.checksum);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.specificity == null ? 0 : this.specificity.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (!Arrays.equals(this.checksum, other.checksum)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.specificity == null ? other.specificity != null : !this.specificity.equals(other.specificity)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "Resource [checksum=" + Bytes.asList((byte[])this.checksum) + ", name=" + this.name + ", path=" + this.path + ", specificity=" + this.specificity + ", url=" + this.url + "]";
    }

    public static class Builder {
        private String name;
        private URI url;
        private byte[] checksum;
        private String path;
        private String specificity = "default";

        public Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            return this;
        }

        public Builder url(URI url) {
            this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
            return this;
        }

        public Builder checksum(byte[] checksum) {
            this.checksum = (byte[])Preconditions.checkNotNull((Object)checksum, (Object)"checksum");
            return this;
        }

        public Builder path(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            return this;
        }

        public Builder specificity(String specificity) {
            this.specificity = (String)Preconditions.checkNotNull((Object)specificity, (Object)"specificity");
            return this;
        }

        public Builder fromPayload(FilePayload payload) {
            Preconditions.checkNotNull((Object)payload, (Object)"payload");
            this.name(((File)payload.getRawContent()).getName());
            this.checksum(payload.getContentMetadata().getContentMD5());
            this.path(((File)payload.getRawContent()).getPath());
            return this;
        }

        public Resource build() {
            return new Resource(this.name, this.url, this.checksum, this.path, this.specificity);
        }
    }
}

