/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.FloatCollection;
import bak.pcj.adapter.CollectionToFloatCollectionAdapter;
import bak.pcj.adapter.SetToIntSetAdapter;
import bak.pcj.map.AbstractIntKeyFloatMap;
import bak.pcj.map.IntKeyFloatMap;
import bak.pcj.map.IntKeyFloatMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.IntSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToIntKeyFloatMapAdapter
extends AbstractIntKeyFloatMap
implements IntKeyFloatMap {
    protected Map map;
    protected Float lastValue;

    public MapToIntKeyFloatMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToIntKeyFloatMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(int key) {
        this.lastValue = (Float)this.map.get(new Integer(key));
        return this.lastValue != null;
    }

    public boolean containsValue(float value) {
        return this.map.containsValue(new Float(value));
    }

    public IntKeyFloatMapIterator entries() {
        return new IntKeyFloatMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToIntKeyFloatMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public int getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Integer)this.lastEntry.getKey();
            }

            public float getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getValue()).floatValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public float get(int key) {
        Float value = (Float)this.map.get(new Integer(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public IntSet keySet() {
        return new SetToIntSetAdapter(this.map.keySet());
    }

    public float lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.floatValue();
    }

    public float put(int key, float value) {
        Float oldValue = this.map.put(new Integer(key), new Float(value));
        return oldValue == null ? MapDefaults.defaultFloat() : oldValue.floatValue();
    }

    public float remove(int key) {
        Float value = (Float)this.map.remove(new Integer(key));
        return value == null ? MapDefaults.defaultFloat() : value.floatValue();
    }

    public int size() {
        return this.map.size();
    }

    public FloatCollection values() {
        return new CollectionToFloatCollectionAdapter(this.map.values());
    }

    public float tget(int key) {
        Float value = (Float)this.map.get(new Integer(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.floatValue();
    }

    public boolean validate() {
        return Adapter.isIntKeyFloatAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

