/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;

public class JpaNamespaceTransformingEventReader
extends EventReaderDelegate {
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String DEFAULT_VERSION = "2.1";
    private static final String DEFAULT_PERSISTENCE_NAMESPACE = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final String DEFAULT_ORM_NAMESPACE = "http://xmlns.jcp.org/xml/ns/persistence/orm";
    private static final Map<String, String> NAMESPACE_MAPPING = new HashMap<String, String>(2);
    private static final Map<String, String> START_ELEMENT_TO_NAMESPACE_URI;
    private static final String EMPTY_PREFIX = "";
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private String currentDocumentNamespaceUri;

    public JpaNamespaceTransformingEventReader(XMLEventReader reader) {
        super(reader);
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        return this.wrap(super.peek());
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        return this.wrap(super.nextEvent());
    }

    private XMLEvent wrap(XMLEvent event) {
        if (event != null && event.isStartElement()) {
            return this.transform(event.asStartElement());
        }
        return event;
    }

    private StartElement transform(StartElement startElement) {
        String elementName = startElement.getName().getLocalPart();
        if (START_ELEMENT_TO_NAMESPACE_URI.containsKey(elementName)) {
            this.currentDocumentNamespaceUri = START_ELEMENT_TO_NAMESPACE_URI.get(elementName);
        }
        List<Attribute> newElementAttributeList = this.updateElementAttributes(startElement);
        List<Namespace> newNamespaceList = this.updateElementNamespaces(startElement);
        return this.xmlEventFactory.createStartElement(new QName(this.currentDocumentNamespaceUri, startElement.getName().getLocalPart()), newElementAttributeList.iterator(), newNamespaceList.iterator());
    }

    private List<Namespace> updateElementNamespaces(StartElement startElement) {
        ArrayList<Namespace> newNamespaceList = new ArrayList<Namespace>();
        Iterator<Namespace> existingNamespaceIterator = startElement.getNamespaces();
        while (existingNamespaceIterator.hasNext()) {
            Namespace namespace = existingNamespaceIterator.next();
            if (NAMESPACE_MAPPING.containsKey(namespace.getNamespaceURI())) {
                newNamespaceList.add(this.xmlEventFactory.createNamespace(EMPTY_PREFIX, this.currentDocumentNamespaceUri));
                continue;
            }
            newNamespaceList.add(namespace);
        }
        if (newNamespaceList.isEmpty()) {
            newNamespaceList.add(this.xmlEventFactory.createNamespace(EMPTY_PREFIX, this.currentDocumentNamespaceUri));
        }
        return newNamespaceList;
    }

    private List<Attribute> updateElementAttributes(StartElement startElement) {
        ArrayList<Attribute> newElementAttributeList = new ArrayList<Attribute>();
        Iterator<Attribute> existingAttributesIterator = startElement.getAttributes();
        while (existingAttributesIterator.hasNext()) {
            Attribute attribute = existingAttributesIterator.next();
            if (VERSION_ATTRIBUTE_NAME.equals(attribute.getName().getLocalPart())) {
                if (DEFAULT_VERSION.equals(attribute.getName().getPrefix())) continue;
                newElementAttributeList.add(this.xmlEventFactory.createAttribute(attribute.getName(), DEFAULT_VERSION));
                continue;
            }
            newElementAttributeList.add(attribute);
        }
        return newElementAttributeList;
    }

    static {
        NAMESPACE_MAPPING.put("http://java.sun.com/xml/ns/persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        NAMESPACE_MAPPING.put("http://java.sun.com/xml/ns/persistence/orm", DEFAULT_ORM_NAMESPACE);
        START_ELEMENT_TO_NAMESPACE_URI = new HashMap<String, String>(2);
        START_ELEMENT_TO_NAMESPACE_URI.put("persistence", DEFAULT_PERSISTENCE_NAMESPACE);
        START_ELEMENT_TO_NAMESPACE_URI.put("entity-mappings", DEFAULT_ORM_NAMESPACE);
    }
}

