/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.AbstractMetadata_;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.MetadataHarvestInfo_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Metadata_;
import org.springframework.data.jpa.domain.Specification;

public final class MetadataSpecs {
    private MetadataSpecs() {
    }

    public static Specification<? extends AbstractMetadata> hasSchemaId(final String schemaId) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path schemaIdPath = root.get(AbstractMetadata_.dataInfo).get(MetadataDataInfo_.schemaId);
                return cb.equal((Expression)schemaIdPath, cb.literal((Object)schemaId));
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasOwner(final int owner) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path ownerPath = root.get(AbstractMetadata_.sourceInfo).get(MetadataSourceInfo_.owner);
                return cb.equal((Expression)ownerPath, cb.literal((Object)owner));
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasMetadataId(final int metadataId) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userIdAttributePath = root.get(AbstractMetadata_.id);
                return cb.equal((Expression)userIdAttributePath, cb.literal((Object)metadataId));
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasMetadataUuid(final String uuid) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userNameAttributePath = root.get(AbstractMetadata_.uuid);
                return cb.equal((Expression)userNameAttributePath, cb.literal((Object)uuid));
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasHarvesterUuid(final String harvesterUuid) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userNameAttributePath = root.get(AbstractMetadata_.harvestInfo).get(MetadataHarvestInfo_.uuid);
                Predicate uuidEqualPredicate = cb.equal((Expression)userNameAttributePath, cb.literal((Object)harvesterUuid));
                return uuidEqualPredicate;
            }
        };
    }

    public static Specification<? extends AbstractMetadata> isOwnedByUser(final int userId) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path ownerPath = root.get(AbstractMetadata_.sourceInfo).get(MetadataSourceInfo_.owner);
                Predicate equalUserIdPredicate = cb.equal((Expression)ownerPath, cb.literal((Object)userId));
                return equalUserIdPredicate;
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasSource(final String sourceUuid) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path sourceAttributePath = root.get(AbstractMetadata_.sourceInfo).get(MetadataSourceInfo_.sourceId);
                Predicate equalSourceIdPredicate = cb.equal((Expression)sourceAttributePath, cb.literal((Object)sourceUuid));
                return equalSourceIdPredicate;
            }
        };
    }

    public static Specification<? extends AbstractMetadata> isType(final MetadataType type) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path templateAttributePath = root.get(AbstractMetadata_.dataInfo).get(MetadataDataInfo_.type_JPAWorkaround);
                Predicate equalTemplatePredicate = cb.equal((Expression)templateAttributePath, cb.literal((Object)Character.valueOf(type.code)));
                return equalTemplatePredicate;
            }
        };
    }

    public static Specification<? extends AbstractMetadata> isHarvested(final boolean isHarvested) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path userNameAttributePath = root.get(AbstractMetadata_.harvestInfo).get(MetadataHarvestInfo_.harvested_JPAWorkaround);
                Predicate equalHarvestPredicate = cb.equal((Expression)userNameAttributePath, cb.literal((Object)Character.valueOf(Constants.toYN_EnabledChar(isHarvested))));
                return equalHarvestPredicate;
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasMetadataIdIn(final Collection<Integer> mdIds) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(AbstractMetadata_.id).in(mdIds);
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasMetadataUuidIn(final Collection<String> uuids) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(AbstractMetadata_.uuid).in(uuids);
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasType(final MetadataType metadataType) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path typeChar = root.get(AbstractMetadata_.dataInfo).get(MetadataDataInfo_.type_JPAWorkaround);
                return cb.equal((Expression)typeChar, (Object)Character.valueOf(metadataType.code));
            }
        };
    }

    public static Specification<? extends AbstractMetadata> isOwnedByOneOfFollowingGroups(final List<Integer> groups) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return root.get(AbstractMetadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner).in((Collection)groups);
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasCategory(final MetadataCategory category) {
        return new Specification<Metadata>(){

            public Predicate toPredicate(Root<Metadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Expression categoriesPath = root.get(Metadata_.metadataCategories);
                return cb.isMember((Object)category, categoriesPath);
            }
        };
    }

    public static Specification<? extends AbstractMetadata> hasExtra(final String extra) {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return cb.equal((Expression)root.get(AbstractMetadata_.dataInfo).get(MetadataDataInfo_.extra), (Object)extra);
            }
        };
    }

    public static Specification<? extends AbstractMetadata> isIso19139Schema() {
        return new Specification<AbstractMetadata>(){

            public Predicate toPredicate(Root<AbstractMetadata> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path schemaIdAttributePath = root.get(AbstractMetadata_.dataInfo).get(MetadataDataInfo_.schemaId);
                Predicate likeSchemaIdPredicate = cb.like((Expression)schemaIdAttributePath, cb.literal((Object)"iso19139"));
                return likeSchemaIdPredicate;
            }
        };
    }
}

