/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.domain;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jclouds.sqs.domain.BatchError;

public class BatchResult<V>
extends ForwardingMap<String, V> {
    private final Map<String, V> results;
    private final Map<String, BatchError> errors;

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    public Builder<V> toBuilder() {
        return BatchResult.builder().fromBatchResult(this);
    }

    private BatchResult(Map<String, V> results, Iterable<BatchError> errors) {
        this.results = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(results, (Object)"results")));
        this.errors = Maps.uniqueIndex((Iterable)((Iterable)Preconditions.checkNotNull(errors, (Object)"errors")), (Function)new Function<BatchError, String>(){

            public String apply(BatchError in) {
                return in.getId();
            }
        });
    }

    protected Map<String, V> delegate() {
        return this.results;
    }

    public Map<String, BatchError> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.results, this.errors});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BatchResult that = (BatchResult)((Object)BatchResult.class.cast(obj));
        return Objects.equal(this.results, that.results) && Objects.equal(this.errors, that.errors);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("results", this.results).add("errors", this.errors).toString();
    }

    public static class Builder<V> {
        private ImmutableMap.Builder<String, V> results = ImmutableMap.builder();
        private ImmutableSet.Builder<BatchError> errors = ImmutableSet.builder();

        public Builder<V> addError(BatchError error) {
            this.errors.add(Preconditions.checkNotNull((Object)error, (Object)"error"));
            return this;
        }

        public Builder<V> errors(Iterable<BatchError> errors) {
            this.errors = ImmutableSet.builder().addAll((Iterable)Preconditions.checkNotNull(errors, (Object)"errors"));
            return this;
        }

        public Builder<V> putAll(Map<String, V> results) {
            this.results.putAll((Map)Preconditions.checkNotNull(results, (Object)"results"));
            return this;
        }

        public Builder<V> put(String name, V value) {
            this.results.put(Preconditions.checkNotNull((Object)name, (Object)"name"), Preconditions.checkNotNull(value, (Object)"value"));
            return this;
        }

        public BatchResult<V> build() {
            return new BatchResult((Map)this.results.build(), (Iterable)this.errors.build());
        }

        public Builder<V> fromBatchResult(BatchResult<V> in) {
            return this.putAll((Map<String, V>)((Object)in)).errors(in.getErrors().values());
        }
    }
}

