/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSPositiveIntegerBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.POSITIVEINTEGER;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return BigInteger.class;
    }

    @Override
    public Object parse(InstanceComponent instance, Object value) throws Exception {
        Number number = (Number)value;
        if (number.longValue() < 1L) {
            throw new IllegalArgumentException("positiveInteger value '" + number + "' must be positive.");
        }
        return BigInteger.valueOf(number.longValue());
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        Number number = (Number)object;
        if (number.longValue() == 0L) {
            throw new IllegalArgumentException("positiveInteger value '" + number + "' must be positive.");
        }
        return value;
    }
}

