/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.xml.ZoneHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ZoneListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<Zone>> {
    private final ZoneHandler zoneHandler;
    private ImmutableSet.Builder<Zone> zones = ImmutableSet.builder();

    @Inject
    public ZoneListHandler(ZoneHandler zoneHandler) {
        this.zoneHandler = zoneHandler;
    }

    public FluentIterable<Zone> getResult() {
        return FluentIterable.from((Iterable)this.zones.build());
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"UltraZone")) {
            this.zoneHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"UltraZone")) {
            this.zones.add((Object)this.zoneHandler.getResult());
        }
    }
}

