/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.spatial.GridSpatialRepresentationImpl;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Dimension;
import org.opengis.metadata.spatial.Georeferenceable;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;

public class GeoreferenceableImpl
extends GridSpatialRepresentationImpl
implements Georeferenceable {
    private static final long serialVersionUID = 5203270142818028946L;
    private boolean controlPointAvailable;
    private boolean orientationParameterAvailable;
    private InternationalString orientationParameterDescription;
    private Record georeferencedParameters;
    private Collection<Citation> parameterCitation;

    public GeoreferenceableImpl() {
    }

    public GeoreferenceableImpl(Georeferenceable source) {
        super(source);
    }

    public GeoreferenceableImpl(int numberOfDimensions, List<? extends Dimension> axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable, boolean controlPointAvailable, boolean orientationParameterAvailable) {
        super(numberOfDimensions, axisDimensionsProperties, cellGeometry, transformationParameterAvailable);
        this.setControlPointAvailable(controlPointAvailable);
        this.setOrientationParameterAvailable(orientationParameterAvailable);
    }

    @Override
    public boolean isControlPointAvailable() {
        return this.controlPointAvailable;
    }

    public void setControlPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.controlPointAvailable = newValue;
    }

    @Override
    public boolean isOrientationParameterAvailable() {
        return this.orientationParameterAvailable;
    }

    public void setOrientationParameterAvailable(boolean newValue) {
        this.checkWritePermission();
        this.orientationParameterAvailable = newValue;
    }

    @Override
    public InternationalString getOrientationParameterDescription() {
        return this.orientationParameterDescription;
    }

    public void setOrientationParameterDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.orientationParameterDescription = newValue;
    }

    @Override
    public Record getGeoreferencedParameters() {
        return this.georeferencedParameters;
    }

    public void setGeoreferencedParameters(Record newValue) {
        this.checkWritePermission();
        this.georeferencedParameters = newValue;
    }

    public Collection<Citation> getParameterCitation() {
        this.parameterCitation = this.nonNullCollection(this.parameterCitation, Citation.class);
        return this.parameterCitation;
    }

    public void setParameterCitation(Collection<? extends Citation> newValues) {
        this.parameterCitation = this.copyCollection(newValues, this.parameterCitation, Citation.class);
    }
}

