/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.languages;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.neovisionaries.i18n.LanguageCode;
import javax.annotation.PostConstruct;
import org.fao.geonet.domain.IsoLanguage;
import org.fao.geonet.repository.IsoLanguageRepository;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public class IsoLanguagesMapper {
    protected BiMap<String, String> _isoLanguagesMap639 = HashBiMap.create();
    @Autowired
    private IsoLanguageRepository _langRepo;

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @PostConstruct
    public void init() {
        for (IsoLanguage record : this._langRepo.findAll()) {
            String shortCode = this.toLowerCase(record.getShortCode());
            String code = this.toLowerCase(record.getCode());
            if (shortCode != null && code != null) {
                this._isoLanguagesMap639.forcePut((Object)shortCode, (Object)code);
                continue;
            }
            Log.info((String)"geonetwork", (Object)("Unable to add IsoLanguage mapping for " + record));
        }
    }

    public void reinit() {
        this._isoLanguagesMap639 = HashBiMap.create();
        this.init();
    }

    private String toLowerCase(String code) {
        if (code == null) {
            return null;
        }
        return code.toLowerCase();
    }

    public String iso639_1_to_iso639_2(String iso639_1) {
        if (this._isoLanguagesMap639.containsValue((Object)iso639_1.toLowerCase())) {
            return iso639_1.toLowerCase();
        }
        return (String)this._isoLanguagesMap639.get((Object)iso639_1.toLowerCase());
    }

    public String iso639_2_to_iso639_1(String iso639_2) {
        if (this._isoLanguagesMap639.containsKey((Object)iso639_2.toLowerCase())) {
            return iso639_2.toLowerCase();
        }
        return (String)this._isoLanguagesMap639.inverse().get((Object)iso639_2.toLowerCase());
    }

    public String iso639_1_to_iso639_2(String iso639_1, String defaultLang) {
        String result = this.iso639_1_to_iso639_2(iso639_1);
        if (result == null) {
            return defaultLang.toLowerCase();
        }
        return result;
    }

    public String iso639_2_to_iso639_1(String iso639_2, String defaultLang) {
        String result = this.iso639_2_to_iso639_1(iso639_2);
        if (result == null) {
            return defaultLang.toLowerCase();
        }
        return result;
    }

    public static String iso639_2B_to_iso639_2T(String iso639_2B) {
        LanguageCode code = LanguageCode.getByCode((String)iso639_2B);
        if (code == null) {
            return iso639_2B;
        }
        return code.getAlpha3().getAlpha3T().name();
    }

    public static String iso639_2T_to_iso639_2B(String iso639_2T) {
        LanguageCode code = LanguageCode.getByCode((String)iso639_2T);
        if (code == null) {
            return iso639_2T;
        }
        return code.getAlpha3().getAlpha3B().name();
    }
}

