/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.util.ThreadUtils;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class BatchOpsMetadataReindexer
extends MetadataIndexerProcessor
implements Runnable {
    private static final JmxRemovalListener removalListener = new JmxRemovalListener();
    private static final Cache<ObjectName, ObjectName> PROBE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).removalListener((RemovalListener)removalListener).build();
    private final Set<Integer> metadata;
    private ExecutorService executor = null;
    private ObjectName probeName;
    private final int toProcessCount;
    private final AtomicInteger processed = new AtomicInteger();
    private final AtomicInteger inError = new AtomicInteger();
    private CompletableFuture<Void> allCompleted;
    private final MBeanExporter exporter;

    public BatchOpsMetadataReindexer(DataManager dm, Set<Integer> metadata) {
        super(dm);
        this.metadata = metadata;
        this.toProcessCount = metadata.size();
        this.exporter = (MBeanExporter)ApplicationContextHolder.get().getBean(MBeanExporter.class);
        removalListener.setExporter(this.exporter);
    }

    @ManagedAttribute
    public int getToProcessCount() {
        return this.toProcessCount;
    }

    @ManagedAttribute
    public int getProcessed() {
        return this.processed.intValue();
    }

    @ManagedAttribute
    public int getInError() {
        return this.inError.intValue();
    }

    public void process(String catalogueId, boolean runInCurrentThread) throws Exception {
        this.wrapAsyncProcess(catalogueId, runInCurrentThread);
        this.allCompleted.get();
    }

    @Override
    public void process(String catalogueId) throws Exception {
        this.process(catalogueId, false);
    }

    public String wrapAsyncProcess(String catalogueId, boolean runInCurrentThread) throws Exception {
        this.probeName = new ObjectName(String.format("geonetwork-%s:name=indexing-task,idx=%s", catalogueId, this.hashCode()));
        this.exporter.registerManagedResource((Object)this, this.probeName);
        return this.processAsync(runInCurrentThread);
    }

    private String processAsync(boolean runInCurrentThread) throws Exception {
        int count;
        int threadCount = ThreadUtils.getNumberOfThreads();
        this.executor = runInCurrentThread ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(threadCount);
        int[] ids = this.metadata.stream().mapToInt(i -> i).toArray();
        int perThread = ids.length < threadCount ? ids.length : ids.length / threadCount;
        ArrayList jobs = Lists.newArrayList();
        for (int index = 0; index < ids.length; index += count) {
            int start = index;
            count = Math.min(perThread, ids.length - start);
            BatchOpsCallable task = new BatchOpsCallable(ids, start, count);
            jobs.add(task);
        }
        ArrayList submitList = Lists.newArrayList();
        for (BatchOpsCallable job : jobs) {
            CompletableFuture<Void> completed = CompletableFuture.runAsync(job, this.executor);
            submitList.add(completed);
        }
        this.allCompleted = CompletableFuture.allOf(submitList.toArray(new CompletableFuture[submitList.size()]));
        this.allCompleted.thenRun(this);
        return this.probeName.toString();
    }

    @Override
    public void run() {
        this.executor.shutdown();
        PROBE_CACHE.cleanUp();
        PROBE_CACHE.put((Object)this.probeName, (Object)this.probeName);
    }

    private final class BatchOpsCallable
    implements Runnable {
        private final int[] ids;
        private final int beginIndex;
        private final int count;

        BatchOpsCallable(int[] ids, int beginIndex, int count) {
            this.ids = ids;
            this.beginIndex = beginIndex;
            this.count = count;
        }

        @Override
        public void run() {
            for (int i = this.beginIndex; i < this.beginIndex + this.count; ++i) {
                try {
                    BatchOpsMetadataReindexer.this.dm.indexMetadata(this.ids[i] + "", false);
                    BatchOpsMetadataReindexer.this.processed.incrementAndGet();
                    continue;
                }
                catch (Exception e) {
                    BatchOpsMetadataReindexer.this.inError.incrementAndGet();
                }
            }
            ((EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class)).forceIndexChanges();
        }
    }

    private static class JmxRemovalListener
    implements RemovalListener<ObjectName, ObjectName> {
        private MBeanExporter exporter;

        private JmxRemovalListener() {
        }

        public void onRemoval(RemovalNotification<ObjectName, ObjectName> removalNotification) {
            this.exporter.unregisterManagedResource((ObjectName)removalNotification.getValue());
        }

        public void setExporter(MBeanExporter exporter) {
            this.exporter = exporter;
        }
    }
}

