/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ThesaurusActivation;
import org.fao.geonet.kernel.AllThesaurus;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.oaipmh.Lib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.repository.ThesaurusActivationRepository;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sailimpl.memory.RdfSchemaRepositoryConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ThesaurusManager
implements ThesaurusFinder {
    @Autowired
    private SettingManager settingManager;
    @Autowired
    private GeonetworkDataDirectory geonetworkDataDirectory;
    @Autowired
    private IMetadataUtils iMetadataUtils;
    @Autowired
    private IMetadataManager metadataManager;
    @Autowired
    private IsoLanguagesMapper isoLanguagesMapper;
    @Autowired
    private ThesaurusActivationRepository thesaurusActivationRepository;
    @Autowired
    private IMetadataSchemaUtils metadataSchemaUtils;
    @Autowired
    private AllThesaurus allThesaurus;
    private ConcurrentHashMap<String, Thesaurus> thesauriMap = new ConcurrentHashMap();
    private LocalService service = null;
    private Path thesauriDirectory = null;
    private boolean initialized = false;

    public synchronized void init(boolean isTest, ServiceContext context, String thesauriRepository) throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String siteURL = this.settingManager.getSiteURL(context);
        this.allThesaurus.init(siteURL);
        this.service = Sesame.getService();
        Path thesauriDir = IO.toPath((String)thesauriRepository, (String[])new String[0]);
        if (!Files.exists(thesauriDir, new LinkOption[0])) {
            thesauriDir = this.geonetworkDataDirectory.resolveWebResource(thesauriRepository);
        }
        thesauriDir = thesauriDir.toAbsolutePath();
        this.thesauriDirectory = thesauriDir.toAbsolutePath();
        this.batchBuildTable(isTest, context, thesauriDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchBuildTable(boolean synchRun, ServiceContext context, Path thesauriDir) {
        ExecutorService executor = null;
        try {
            InitThesauriTableTask worker = new InitThesauriTableTask(context, thesauriDir);
            if (synchRun) {
                worker.run();
            } else {
                executor = Executors.newFixedThreadPool(1);
                executor.execute(worker);
            }
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    private void initThesauriTable(Path thesauriDirectory, ServiceContext context) throws IOException {
        this.thesauriMap = new ConcurrentHashMap();
        Log.info((String)"geonetwork.thesaurus-man", (Object)("Scanning " + thesauriDirectory));
        if (thesauriDirectory != null && Files.isDirectory(thesauriDirectory, new LinkOption[0])) {
            String[] types;
            for (String type : types = new String[]{"external", "local", "register"}) {
                Path externalThesauriDirectory = thesauriDirectory.resolve(type).resolve("thesauri");
                if (!Files.isDirectory(externalThesauriDirectory, new LinkOption[0])) continue;
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(externalThesauriDirectory, IO.DIRECTORIES_FILTER);){
                    for (Path aRdfDataDirectory : paths) {
                        this.loadRepositories(aRdfDataDirectory, type, context);
                    }
                }
            }
        }
    }

    private void loadRepositories(Path thesauriDirectory, String root, ServiceContext context) throws IOException {
        String siteURL = this.settingManager.getSiteURL(context);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(thesauriDirectory, "*.rdf");){
            for (Path aRdfDataFile : paths) {
                Thesaurus gst;
                String rdfFileName = aRdfDataFile.getFileName().toString();
                String thesaurusDirName = thesauriDirectory.getFileName().toString();
                if (root.equals("register")) {
                    if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
                        Log.debug((String)"geonetwork.thesaurus-man", (Object)("Creating thesaurus : " + aRdfDataFile));
                    }
                    Path outputRdf = thesauriDirectory.resolve(aRdfDataFile);
                    String uuid = com.google.common.io.Files.getNameWithoutExtension((String)rdfFileName);
                    try (OutputStream outputRdfStream = Files.newOutputStream(outputRdf, new OpenOption[0]);){
                        this.getRegisterMetadataAsRdf(uuid, outputRdfStream, context);
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.thesaurus-man", (Object)("Register thesaurus " + aRdfDataFile + " could not be read/converted from ISO19135 record in catalog - skipping"), (Throwable)e);
                        continue;
                    }
                    gst = new Thesaurus(this.isoLanguagesMapper, rdfFileName, root, thesaurusDirName, outputRdf, siteURL);
                } else {
                    gst = new Thesaurus(this.isoLanguagesMapper, rdfFileName, root, thesaurusDirName, thesauriDirectory.resolve(aRdfDataFile), siteURL);
                }
                try {
                    this.addThesaurus(gst, false);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.thesaurus-man", (Object)("Error adding thesaurus " + aRdfDataFile + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void getRegisterMetadataAsRdf(String uuid, OutputStream os, ServiceContext context) throws Exception {
        AbstractMetadata mdInfo = this.iMetadataUtils.findOneByUuid(uuid);
        Integer id = mdInfo.getId();
        Element md = this.metadataManager.getMetadata("" + id);
        Processor.detachXLink(md, context);
        String siteURL = this.settingManager.getSiteURL(context);
        Element env = Lib.prepareTransformEnv(mdInfo.getUuid(), mdInfo.getDataInfo().getChangeDate().getDateAndTime(), "", siteURL, "");
        Element root = new Element("root");
        root.addContent((Content)md);
        root.addContent((Content)env);
        Path styleSheet = this.metadataSchemaUtils.getSchemaDir("iso19135").resolve("convert").resolve("xml_iso19135ToSKOS.xsl");
        Xml.transform((Element)root, (Path)styleSheet, (OutputStream)os);
    }

    public Path buildThesaurusFilePath(String fname, String type, String dname) throws IOException {
        Path dirPath = this.thesauriDirectory.resolve(type).resolve("thesauri").resolve(dname);
        Files.createDirectories(dirPath, new FileAttribute[0]);
        return dirPath.resolve(fname);
    }

    public void addThesaurus(Thesaurus gst, boolean writeConceptScheme) throws Exception {
        String thesaurusName = gst.getKey();
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
            Log.debug((String)"geonetwork.thesaurus-man", (Object)("Adding thesaurus : " + thesaurusName));
        }
        if (this.existsThesaurus(thesaurusName)) {
            throw new Exception("A thesaurus exists with code " + thesaurusName);
        }
        this.createThesaurusRepository(gst);
        this.thesauriMap.put(thesaurusName, gst);
        if (writeConceptScheme) {
            gst.writeConceptScheme(gst.getTitle(), gst.getDescription(), gst.getFname(), gst.getDname(), gst.getDefaultNamespace());
        }
    }

    public void addOrReloadThesaurus(Thesaurus gst) throws Exception {
        if (this.thesauriMap.replace(gst.getKey(), gst) != null) {
            this.service.removeRepository(gst.getKey());
        }
        this.createThesaurusRepository(gst);
        this.thesauriMap.put(gst.getKey(), gst);
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
            Log.debug((String)"geonetwork.thesaurus-man", (Object)("Thesaurus " + gst.getKey() + " loaded."));
        }
    }

    public void remove(String name) {
        this.service.removeRepository(name);
        this.thesauriMap.remove(name);
    }

    private void createThesaurusRepository(Thesaurus gst) throws Exception {
        try {
            RepositoryConfig repConfig = new RepositoryConfig(gst.getKey());
            SailConfig syncSail = new SailConfig("org.openrdf.sesame.sailimpl.sync.SyncRdfSchemaRepository");
            RdfSchemaRepositoryConfig memSail = new RdfSchemaRepositoryConfig(gst.getFile().toAbsolutePath().toString(), RDFFormat.RDFXML);
            repConfig.addSail(syncSail);
            repConfig.addSail((SailConfig)memSail);
            repConfig.setWorldReadable(true);
            repConfig.setWorldWriteable(true);
            LocalRepository thesaurusRepository = this.service.createRepository(repConfig);
            gst.setRepository(thesaurusRepository);
        }
        catch (ConfigurationException e) {
            Log.error((String)"geonetwork.thesaurus-man", (Object)"Create Thesaurus Repository error", (Throwable)e);
            throw e;
        }
    }

    public Path getThesauriDirectory() {
        return this.thesauriDirectory;
    }

    @Override
    public Map<String, Thesaurus> getThesauriMap() {
        if (this.settingManager.getValueAsBool("system/metadata/allThesaurus")) {
            HashMap all = Maps.newHashMap(this.thesauriMap);
            all.put(this.allThesaurus.getKey(), this.allThesaurus);
            return all;
        }
        return Collections.unmodifiableMap(this.thesauriMap);
    }

    @Override
    @Nullable
    public Thesaurus getThesaurusByName(@Nonnull String thesaurusName) {
        return this.getThesauriMap().get(thesaurusName);
    }

    @Override
    public Thesaurus getThesaurusByConceptScheme(String uri) {
        for (Map.Entry<String, Thesaurus> entry : this.getThesauriMap().entrySet()) {
            try {
                Thesaurus thesaurus = entry.getValue();
                if (!thesaurus.hasConceptScheme(uri)) continue;
                return thesaurus;
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.thesaurus-man", (Object)"Get Thesaurus By Concept Scheme error", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean existsThesaurus(String name) {
        return this.getThesauriMap().get(name) != null;
    }

    public String createUpdateThesaurusFromRegister(String uuid, String type, ServiceContext context) throws Exception {
        String root = "register";
        String aRdfDataFile = uuid + ".rdf";
        Path thesaurusFile = this.buildThesaurusFilePath(aRdfDataFile, root, type);
        String siteURL = this.settingManager.getSiteURL(context);
        Thesaurus gst = new Thesaurus(this.isoLanguagesMapper, aRdfDataFile, root, type, thesaurusFile, siteURL);
        try (OutputStream outputRdfStream = Files.newOutputStream(thesaurusFile, new OpenOption[0]);){
            this.getRegisterMetadataAsRdf(uuid, outputRdfStream, context);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.thesaurus-man", (Object)("Register thesaurus " + aRdfDataFile + " could not be read/converted from ISO19135 record in catalog - skipping"), (Throwable)e);
        }
        String theKey = gst.getKey();
        gst.retrieveThesaurusTitle();
        this.addOrReloadThesaurus(gst);
        return theKey;
    }

    public Element buildResultfromThTable(ServiceContext context) throws SQLException, JDOMException, IOException {
        Element elRoot = new Element("thesauri");
        Collection<Thesaurus> e = this.getThesauriMap().values();
        for (Thesaurus currentTh : e) {
            Element elLoop = new Element("thesaurus");
            Element elKey = new Element("key");
            String key = currentTh.getKey();
            elKey.addContent(key);
            Element elDname = new Element("dname");
            String dname = currentTh.getDname();
            elDname.addContent(dname);
            Element description = new Element("description");
            description.addContent(currentTh.getDescription());
            Element elFname = new Element("filename");
            String fname = currentTh.getFname();
            elFname.addContent(fname);
            Element elTitle = new Element("title");
            String title = currentTh.getTitles((ApplicationContext)context.getApplicationContext()).get(context.getLanguage());
            if (title == null) {
                title = currentTh.getTitle();
            }
            elTitle.addContent(title);
            Element elMultilingualTitles = new Element("multilingualTitles");
            for (Map.Entry<String, String> entry : currentTh.getMultilingualTitles().entrySet()) {
                Element elMultilingualTitle = new Element("multilingualTitle");
                Element elMultilingualTitl_lang = new Element("lang");
                elMultilingualTitl_lang.setText(entry.getKey());
                Element elMultilingualTitle_title = new Element("title");
                elMultilingualTitle_title.setText(entry.getValue());
                elMultilingualTitle.addContent((Content)elMultilingualTitl_lang);
                elMultilingualTitle.addContent((Content)elMultilingualTitle_title);
                elMultilingualTitles.addContent((Content)elMultilingualTitle);
            }
            Element elDublinCoreMultilingual = new Element("dublinCoreMultilinguals");
            for (Map.Entry<String, Map<String, String>> entryLang : currentTh.getDublinCoreMultilingual().entrySet()) {
                String lang = entryLang.getKey();
                for (Map.Entry entry : entryLang.getValue().entrySet()) {
                    Element elItem = new Element("dublinCoreMultilingual");
                    Element elLang = new Element("lang");
                    elLang.setText(lang);
                    Element elTag = new Element("tag");
                    elTag.setText((String)entry.getKey());
                    Element elValue = new Element("value");
                    elValue.setText((String)entry.getValue());
                    elItem.addContent((Content)elLang);
                    elItem.addContent((Content)elTag);
                    elItem.addContent((Content)elValue);
                    elDublinCoreMultilingual.addContent((Content)elItem);
                }
            }
            Element element = new Element("type");
            String type = currentTh.getType();
            element.addContent(type);
            Element elDate = new Element("date");
            String date = currentTh.getDate();
            elDate.addContent(date);
            Element element2 = new Element("url");
            String url = currentTh.getDownloadUrl();
            element2.addContent(url);
            Element elDefaultURI = new Element("defaultNamespace");
            String defaultURI = currentTh.getDefaultNamespace();
            elDefaultURI.addContent(defaultURI);
            Element elActivated = new Element("activated");
            char activated = 'y';
            Optional activation = this.thesaurusActivationRepository.findById((Object)currentTh.getKey());
            if (activation.isPresent() && !((ThesaurusActivation)activation.get()).isActivated()) {
                activated = 'n';
            }
            elActivated.setText("" + activated);
            elLoop.addContent((Content)elKey);
            elLoop.addContent((Content)elDname);
            elLoop.addContent((Content)description);
            elLoop.addContent((Content)elFname);
            elLoop.addContent((Content)elTitle);
            elLoop.addContent((Content)elMultilingualTitles);
            elLoop.addContent((Content)elDublinCoreMultilingual);
            elLoop.addContent((Content)elDate);
            elLoop.addContent((Content)element2);
            elLoop.addContent((Content)elDefaultURI);
            elLoop.addContent((Content)element);
            elLoop.addContent((Content)elActivated);
            elRoot.addContent((Content)elLoop);
        }
        return elRoot;
    }

    final class InitThesauriTableTask
    implements Runnable {
        private final ServiceContext context;
        private final Path thesauriDir;

        InitThesauriTableTask(ServiceContext context, Path thesauriDir) {
            this.context = context;
            this.thesauriDir = thesauriDir;
        }

        @Override
        public void run() {
            this.context.setAsThreadLocal();
            try {
                while (!this.context.isServletInitialized()) {
                    if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
                        Log.debug((String)"geonetwork.thesaurus-man", (Object)"Waiting for servlet to finish initializing..");
                    }
                    Thread.sleep(10000L);
                }
                try {
                    ThesaurusManager.this.initThesauriTable(this.thesauriDir, this.context);
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.thesaurus-man", (Object)("Error rebuilding thesaurus table : " + e.getMessage() + "\n" + Util.getStackTrace((Throwable)e)));
                }
            }
            catch (Exception e) {
                Log.debug((String)"geonetwork.thesaurus-man", (Object)"Thesaurus table rebuilding thread threw exception", (Exception)e);
            }
        }
    }
}

