/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.config;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToAdminURIFromServiceEndpointsForTypeAndVersion;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Suppliers2;

public class KeystoneAdminURLModule
extends AbstractModule {
    protected void configure() {
        this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromServiceEndpointsForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
    }

    @Provides
    @Singleton
    @Identity
    protected final Supplier<URI> provideIdentityAdminUrl(RegionIdToAdminURISupplier.Factory factory, @ApiVersion String version, @Named(value="jclouds.keystone.version") String keystoneVersion, @Provider Supplier<URI> providerURI) {
        Supplier identityServiceForSpecificVersionInType = Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("identityv" + keystoneVersion, version));
        Supplier identityServiceForVersion = Suppliers2.onThrowable((Supplier)identityServiceForSpecificVersionInType, NoSuchElementException.class, (Supplier)Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("identity", version)));
        Supplier whenIdentityServiceIsntListedFallbackToProviderURI = Suppliers2.onThrowable((Supplier)identityServiceForVersion, NoSuchElementException.class, providerURI);
        Supplier whenIdentityServiceHasNoAdminURLFallbackToProviderURI = Suppliers2.or((Supplier)whenIdentityServiceIsntListedFallbackToProviderURI, providerURI);
        return whenIdentityServiceHasNoAdminURLFallbackToProviderURI;
    }
}

