/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.binders.DirectionalGroupCoordinatesToXML;
import org.jclouds.ultradns.ws.domain.AccountLevelGroup;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalGroupCoordinates;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.xml.AccountLevelGroupsHandler;
import org.jclouds.ultradns.ws.xml.DirectionalGroupHandler;
import org.jclouds.ultradns.ws.xml.DirectionalPoolRecordDetailListHandler;
import org.jclouds.ultradns.ws.xml.ItemListHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface DirectionalGroupApi {
    @Named(value="getDirectionalDNSGroupDetails")
    @POST
    @XMLResponseParser(value=DirectionalGroupHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Payload(value="<v01:getDirectionalDNSGroupDetails><GroupId>{GroupId}</GroupId></v01:getDirectionalDNSGroupDetails>")
    @Nullable
    public DirectionalGroup get(@PayloadParam(value="GroupId") String var1);

    @Named(value="getAccountLevelDirectionalGroupsOfZone")
    @POST
    @XMLResponseParser(value=AccountLevelGroupsHandler.class)
    @Payload(value="<v01:getAccountLevelDirectionalGroups><accountId>{accountId}</accountId><GroupType /></v01:getAccountLevelDirectionalGroups>")
    public FluentIterable<AccountLevelGroup> listAccountLevelGroups();

    @Named(value="getDirectionalDNSRecordsForAcctLvlGroup")
    @POST
    @XMLResponseParser(value=DirectionalPoolRecordDetailListHandler.class)
    @Payload(value="<v01:getDirectionalDNSRecordsForAcctLvlGroup><groupId>{groupId}</groupId></v01:getDirectionalDNSRecordsForAcctLvlGroup>")
    public FluentIterable<DirectionalPoolRecordDetail> listRecordsByAccountLevelGroup(@PayloadParam(value="groupId") String var1) throws ResourceNotFoundException;

    @Named(value="getAvailableGroups")
    @POST
    @XMLResponseParser(value=ItemListHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Payload(value="<v01:getAvailableGroups><poolName>{hostName}</poolName><poolRecordType>{rrType}</poolRecordType><accountID>{accountId}</accountID><groupType /></v01:getAvailableGroups>")
    public FluentIterable<String> listGroupNamesByDNameAndType(@PayloadParam(value="hostName") String var1, @PayloadParam(value="rrType") int var2);

    @Named(value="getDirectionalDNSRecordsForGroup")
    @POST
    @XMLResponseParser(value=DirectionalPoolRecordDetailListHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<DirectionalPoolRecordDetail> listRecordsByGroupCoordinates(@BinderParam(value=DirectionalGroupCoordinatesToXML.class) DirectionalGroupCoordinates var1) throws ResourceNotFoundException;
}

