/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public class DashboardAppHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(final ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected HealthCheck.Result check() throws Exception {
                GeonetHttpRequestFactory httpRequestFactory = (GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class);
                SettingManager settingManager = (SettingManager)context.getBean(SettingManager.class);
                EsSearchManager searchMan = (EsSearchManager)context.getBean(EsSearchManager.class);
                String dashboardAppUrl = searchMan.getClient().getDashboardAppUrl();
                if (StringUtils.isNotEmpty((String)dashboardAppUrl)) {
                    try (ClientHttpResponse httpResponse = null;){
                        String url = dashboardAppUrl;
                        httpResponse = httpRequestFactory.execute((HttpUriRequest)new HttpGet(url));
                        if (httpResponse.getRawStatusCode() == 200 || httpResponse.getRawStatusCode() == 404) {
                            HealthCheck.Result result = HealthCheck.Result.healthy((String)String.format("Dashboard application is running.", new Object[0]));
                            return result;
                        }
                        HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"Dashboard application is not available currently. This component is only required if you use dashboards.");
                        return result;
                    }
                }
                return HealthCheck.Result.unhealthy((String)"Dashboard application is not configured. Update config.properties to setup Kibana to use this feature.");
            }
        };
    }
}

