/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.util.Iterator;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.store.kahadaptor.ConsumerMessageRef;

public class TopicSubContainer {
    private transient MapContainer mapContainer;
    private transient StoreEntry batchEntry;

    public TopicSubContainer(MapContainer container) {
        this.mapContainer = container;
    }

    public StoreEntry getBatchEntry() {
        return this.batchEntry;
    }

    public void setBatchEntry(String id, StoreEntry batchEntry) {
        this.batchEntry = batchEntry;
    }

    public void reset() {
        this.batchEntry = null;
    }

    public boolean isEmpty() {
        return this.mapContainer.isEmpty();
    }

    public StoreEntry add(ConsumerMessageRef ref) {
        return this.mapContainer.place(ref.getMessageId(), ref);
    }

    public ConsumerMessageRef remove(MessageId id) {
        ConsumerMessageRef result = null;
        StoreEntry entry = this.mapContainer.getEntry(id);
        if (entry != null) {
            result = (ConsumerMessageRef)this.mapContainer.getValue(entry);
            this.mapContainer.remove(entry);
            if (this.batchEntry != null && this.batchEntry.equals(entry)) {
                this.reset();
            }
        }
        if (this.mapContainer.isEmpty()) {
            this.reset();
        }
        return result;
    }

    public ConsumerMessageRef get(StoreEntry entry) {
        return (ConsumerMessageRef)this.mapContainer.getValue(entry);
    }

    public StoreEntry getEntry() {
        return this.mapContainer.getFirst();
    }

    public StoreEntry refreshEntry(StoreEntry entry) {
        return this.mapContainer.refresh(entry);
    }

    public StoreEntry getNextEntry(StoreEntry entry) {
        return this.mapContainer.getNext(entry);
    }

    public Iterator iterator() {
        return this.mapContainer.values().iterator();
    }

    public int size() {
        return this.mapContainer.size();
    }

    public void clear() {
        this.reset();
        this.mapContainer.clear();
    }
}

