/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.activemq.kaha.ContainerId;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.container.BaseContainerImpl;
import org.apache.activemq.kaha.impl.container.ContainerListIterator;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListContainerImpl
extends BaseContainerImpl
implements ListContainer {
    private static final Logger LOG = LoggerFactory.getLogger(ListContainerImpl.class);
    protected Marshaller marshaller = Store.OBJECT_MARSHALLER;

    public ListContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager, boolean persistentIndex) throws IOException {
        super(id, root, indexManager, dataManager, persistentIndex);
    }

    @Override
    public synchronized void load() {
        this.checkClosed();
        if (!this.loaded && !this.loaded) {
            this.loaded = true;
            try {
                this.init();
                long nextItem = this.root.getNextItem();
                while (nextItem != -1L) {
                    IndexItem item = this.indexManager.getIndex(nextItem);
                    this.indexList.add(item);
                    this.itemAdded(item, this.indexList.size() - 1, this.getValue(item));
                    nextItem = item.getNextItem();
                }
            }
            catch (IOException e) {
                LOG.error("Failed to load container " + this.getId(), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
    }

    @Override
    public synchronized void unload() {
        this.checkClosed();
        if (this.loaded) {
            this.loaded = false;
            this.indexList.clear();
        }
    }

    @Override
    public synchronized void setMarshaller(Marshaller marshaller) {
        this.checkClosed();
        this.marshaller = marshaller;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        this.load();
        boolean result = false;
        if (obj != null && obj instanceof List) {
            List other = (List)obj;
            boolean bl = result = other.size() == this.size();
            if (result) {
                for (int i = 0; i < this.indexList.size(); ++i) {
                    Object o2;
                    Object o1 = other.get(i);
                    boolean bl2 = result = o1 == (o2 = this.get(i)) || o1 != null && o2 != null && o1.equals(o2);
                    if (!result) break;
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized int size() {
        this.load();
        return this.indexList.size();
    }

    @Override
    public synchronized void addFirst(Object o) {
        this.internalAddFirst(o);
    }

    @Override
    public synchronized void addLast(Object o) {
        this.internalAddLast(o);
    }

    @Override
    public synchronized Object removeFirst() {
        this.load();
        Object result = null;
        IndexItem item = this.indexList.getFirst();
        if (item != null) {
            this.itemRemoved(0);
            result = this.getValue(item);
            IndexItem prev = this.root;
            IndexItem next = this.indexList.size() > 1 ? this.indexList.get(1) : null;
            this.indexList.removeFirst();
            this.delete(item, prev, next);
            item = null;
        }
        return result;
    }

    @Override
    public synchronized Object removeLast() {
        this.load();
        Object result = null;
        IndexItem last = this.indexList.getLast();
        if (last != null) {
            this.itemRemoved(this.indexList.size() - 1);
            result = this.getValue(last);
            IndexItem prev = this.indexList.getPrevEntry(last);
            IndexItem next = null;
            this.indexList.removeLast();
            this.delete(last, prev, next);
        }
        return result;
    }

    @Override
    public synchronized boolean isEmpty() {
        this.load();
        return this.indexList.isEmpty();
    }

    @Override
    public synchronized boolean contains(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            IndexItem next = this.indexList.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    result = true;
                    break;
                }
                next = this.indexList.getNextEntry(next);
            }
        }
        return result;
    }

    @Override
    public synchronized Iterator iterator() {
        this.load();
        return this.listIterator();
    }

    @Override
    public synchronized Object[] toArray() {
        this.load();
        ArrayList<Object> tmp = new ArrayList<Object>(this.indexList.size());
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object value = this.getValue(next);
            tmp.add(value);
            next = this.indexList.getNextEntry(next);
        }
        return tmp.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        this.load();
        ArrayList<Object> tmp = new ArrayList<Object>(this.indexList.size());
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object value = this.getValue(next);
            tmp.add(value);
            next = this.indexList.getNextEntry(next);
        }
        return tmp.toArray(a);
    }

    @Override
    public synchronized boolean add(Object o) {
        this.load();
        this.addLast(o);
        return true;
    }

    @Override
    public synchronized boolean remove(Object o) {
        this.load();
        boolean result = false;
        int pos = 0;
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object value = this.getValue(next);
            if (value != null && value.equals(o)) {
                this.remove(next);
                this.itemRemoved(pos);
                result = true;
                break;
            }
            next = this.indexList.getNextEntry(next);
            ++pos;
        }
        return result;
    }

    @Override
    protected synchronized void remove(IndexItem item) {
        IndexItem prev = this.indexList.getPrevEntry(item);
        IndexItem next = this.indexList.getNextEntry(item);
        this.indexList.remove(item);
        this.delete(item, prev, next);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        this.load();
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        this.load();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        this.load();
        boolean result = false;
        ListIterator e1 = this.listIterator(index);
        Iterator e2 = c.iterator();
        while (e2.hasNext()) {
            e1.add(e2.next());
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        this.load();
        boolean result = true;
        for (Object obj : c) {
            result &= this.remove(obj);
        }
        return result;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        this.load();
        ArrayList<Object> tmpList = new ArrayList<Object>();
        IndexItem next = this.indexList.getFirst();
        while (next != null) {
            Object o = this.getValue(next);
            if (!c.contains(o)) {
                tmpList.add(o);
            }
            next = this.indexList.getNextEntry(next);
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        return !tmpList.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.checkClosed();
        super.clear();
        this.doClear();
    }

    @Override
    public synchronized Object get(int index) {
        this.load();
        Object result = null;
        IndexItem item = this.indexList.get(index);
        if (item != null) {
            result = this.getValue(item);
        }
        return result;
    }

    @Override
    public synchronized Object set(int index, Object element) {
        this.load();
        Object result = null;
        IndexItem replace = this.indexList.isEmpty() ? null : this.indexList.get(index);
        IndexItem prev = this.indexList.isEmpty() || index - 1 < 0 ? null : this.indexList.get(index - 1);
        IndexItem next = this.indexList.isEmpty() || index + 1 >= this.size() ? null : this.indexList.get(index + 1);
        result = this.getValue(replace);
        this.indexList.remove(index);
        this.delete(replace, prev, next);
        this.itemRemoved(index);
        this.add(index, element);
        return result;
    }

    protected synchronized IndexItem internalSet(int index, Object element) {
        IndexItem replace = this.indexList.isEmpty() ? null : this.indexList.get(index);
        IndexItem prev = this.indexList.isEmpty() || index - 1 < 0 ? null : this.indexList.get(index - 1);
        IndexItem next = this.indexList.isEmpty() || index + 1 >= this.size() ? null : this.indexList.get(index + 1);
        this.indexList.remove(index);
        this.delete(replace, prev, next);
        this.itemRemoved(index);
        return this.internalAdd(index, element);
    }

    @Override
    public synchronized void add(int index, Object element) {
        this.load();
        IndexItem item = this.insert(index, element);
        this.indexList.add(index, item);
        this.itemAdded(item, index, element);
    }

    protected synchronized StoreEntry internalAddLast(Object o) {
        this.load();
        IndexItem item = this.writeLast(o);
        this.indexList.addLast(item);
        this.itemAdded(item, this.indexList.size() - 1, o);
        return item;
    }

    protected synchronized StoreEntry internalAddFirst(Object o) {
        this.load();
        IndexItem item = this.writeFirst(o);
        this.indexList.addFirst(item);
        this.itemAdded(item, 0, o);
        return item;
    }

    protected synchronized IndexItem internalAdd(int index, Object element) {
        this.load();
        IndexItem item = this.insert(index, element);
        this.indexList.add(index, item);
        this.itemAdded(item, index, element);
        return item;
    }

    protected synchronized StoreEntry internalGet(int index) {
        this.load();
        if (index >= 0 && index < this.indexList.size()) {
            return this.indexList.get(index);
        }
        return null;
    }

    @Override
    public synchronized boolean doRemove(int index) {
        this.load();
        boolean result = false;
        IndexItem item = this.indexList.get(index);
        if (item != null) {
            result = true;
            IndexItem prev = this.indexList.getPrevEntry(item);
            prev = prev != null ? prev : this.root;
            IndexItem next = this.indexList.getNextEntry(prev);
            this.indexList.remove(index);
            this.itemRemoved(index);
            this.delete(item, prev, next);
        }
        return result;
    }

    @Override
    public synchronized Object remove(int index) {
        this.load();
        Object result = null;
        IndexItem item = this.indexList.get(index);
        if (item != null) {
            this.itemRemoved(index);
            result = this.getValue(item);
            IndexItem prev = this.indexList.getPrevEntry(item);
            prev = prev != null ? prev : this.root;
            IndexItem next = this.indexList.getNextEntry(item);
            this.indexList.remove(index);
            this.delete(item, prev, next);
        }
        return result;
    }

    @Override
    public synchronized int indexOf(Object o) {
        this.load();
        int result = -1;
        if (o != null) {
            int count = 0;
            IndexItem next = this.indexList.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    result = count;
                    break;
                }
                ++count;
                next = this.indexList.getNextEntry(next);
            }
        }
        return result;
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        this.load();
        int result = -1;
        if (o != null) {
            int count = this.indexList.size() - 1;
            IndexItem next = this.indexList.getLast();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    result = count;
                    break;
                }
                --count;
                next = this.indexList.getPrevEntry(next);
            }
        }
        return result;
    }

    @Override
    public synchronized ListIterator listIterator() {
        this.load();
        return new ContainerListIterator(this, this.indexList, this.indexList.getRoot());
    }

    @Override
    public synchronized ListIterator listIterator(int index) {
        this.load();
        IndexItem start = index - 1 > 0 ? this.indexList.get(index - 1) : this.indexList.getRoot();
        return new ContainerListIterator(this, this.indexList, start);
    }

    @Override
    public synchronized List<Object> subList(int fromIndex, int toIndex) {
        this.load();
        ArrayList<Object> result = new ArrayList<Object>();
        int count = fromIndex;
        IndexItem next = this.indexList.get(fromIndex);
        while (next != null && count++ < toIndex) {
            result.add(this.getValue(next));
            next = this.indexList.getNextEntry(next);
        }
        return result;
    }

    public synchronized StoreEntry placeLast(Object object) {
        StoreEntry item = this.internalAddLast(object);
        return item;
    }

    public synchronized StoreEntry placeFirst(Object object) {
        StoreEntry item = this.internalAddFirst(object);
        return item;
    }

    public synchronized void update(StoreEntry entry, Object object) {
        try {
            this.dataManager.updateItem(entry.getValueDataItem(), this.marshaller, object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Object get(StoreEntry entry) {
        this.load();
        StoreEntry entryToUse = this.refresh(entry);
        return this.getValue(entryToUse);
    }

    @Override
    public synchronized boolean remove(StoreEntry entry) {
        IndexItem item = (IndexItem)entry;
        this.load();
        boolean result = false;
        if (item != null) {
            this.remove(item);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized StoreEntry getFirst() {
        this.load();
        return this.indexList.getFirst();
    }

    @Override
    public synchronized StoreEntry getLast() {
        this.load();
        return this.indexList.getLast();
    }

    @Override
    public synchronized StoreEntry getNext(StoreEntry entry) {
        this.load();
        IndexItem item = (IndexItem)entry;
        return this.indexList.getNextEntry(item);
    }

    @Override
    public synchronized StoreEntry getPrevious(StoreEntry entry) {
        this.load();
        IndexItem item = (IndexItem)entry;
        return this.indexList.getPrevEntry(item);
    }

    @Override
    public synchronized StoreEntry refresh(StoreEntry entry) {
        this.load();
        return this.indexList.getEntry(entry);
    }

    protected synchronized IndexItem writeLast(Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                StoreLocation data = this.dataManager.storeDataItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = this.indexList.getLast();
                prev = prev != null ? prev : this.root;
                IndexItem next = this.indexList.getNextEntry(prev);
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.updateIndexes(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.updateIndexes(next);
                }
                this.storeIndex(index);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to write " + value, (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected synchronized IndexItem writeFirst(Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                StoreLocation data = this.dataManager.storeDataItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = this.root;
                IndexItem next = this.indexList.getNextEntry(prev);
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.updateIndexes(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.updateIndexes(next);
                }
                this.storeIndex(index);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to write " + value, (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected synchronized IndexItem insert(int insertPos, Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                StoreLocation data = this.dataManager.storeDataItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = null;
                IndexItem next = null;
                if (insertPos <= 0) {
                    prev = this.root;
                    next = this.indexList.getNextEntry(this.root);
                } else if (insertPos >= this.indexList.size()) {
                    prev = this.indexList.getLast();
                    if (prev == null) {
                        prev = this.root;
                    }
                    next = null;
                } else {
                    prev = this.indexList.get(insertPos);
                    prev = prev != null ? prev : this.root;
                    next = this.indexList.getNextEntry(prev);
                }
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.updateIndexes(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.updateIndexes(next);
                }
                this.storeIndex(index);
                this.indexList.setRoot(this.root);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to insert " + value, (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    @Override
    protected synchronized Object getValue(StoreEntry item) {
        Object result = null;
        if (item != null) {
            try {
                StoreLocation data = item.getValueDataItem();
                result = this.dataManager.readItem(this.marshaller, data);
            }
            catch (IOException e) {
                LOG.error("Failed to get value for " + item, (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }

    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            result.append(String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    protected synchronized void itemAdded(IndexItem item, int pos, Object value) {
    }

    protected synchronized void itemRemoved(int pos) {
    }
}

